% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMOptions}
\alias{PCMOptions}
\title{Global options for the PCMBase package}
\usage{
PCMOptions()
}
\value{
a named list with the currently set values of the following global
options:
\itemize{
\item{\code{PCMBase.Value.NA }}{NA value for the likelihood; used in GaussianPCM to
return this value in case of an error occuring
during likelihood calculation. By default, this is set to \code{as.double(NA)}.}
\item{\code{PCMBase.Errors.As.Warnings }}{a logical flag indicating if errors
(occuring, e.g. during likelihood calculation) should be treated as warnings
and added as an attribute "error" to returne likelihood values. Default TRUE.}
\item{\code{PCMBase.Threshold.Lambda_ij }}{a 0-threshold for abs(Lambda_i + Lambda_j),
where Lambda_i and Lambda_j are eigenvalues of the parameter matrix H of an OU or
other model. Default 1e-8. See \code{\link{PCMPExpxMeanExp}}.}
\item{\code{PCMBase.Threshold.SV }}{A 0-threshold for min(svdV)/max(svdV), where
svdV is the vector of eigenvalues of the matrix V for a given branch. The V matrix
is considered singular if it has eigenvalues equal to 0 or when the ratio
min(svdV)/max(svdV) is below PCMBase.Threshold.SV. Default is 1e-6. Treatment
of branches with singular V matrix is defined by the option \code{PCMBase.Skip.Singular}.}
\item{\code{PCMBase.Threshold.Skip.Singular }}{A double indicating if a branch of shorter
length with singular matrix V should be skipped during likelihood calculation. Setting this
option to a higher value, together with a TRUE value for the option PCMBase.Skip.Singular
will result in tolerating some parameter values resulting in singular variance covariance
matrix of the transition distribution. Default 1e-4.}
\item{\code{PCMBase.Skip.Singular }}{A logical value indicating whether branches with
singular matrix V and shorter than \code{getOption("PCMBase.Threshold.Singular.Skip")}
 should be skipped during likelihood calculation, adding their children
L,m,r values to their parent node. Default TRUE. Note, that setting this option to FALSE
may cause some models to stop working, e.g. the White model. Setting this option to FALSE
will also cause errors or NA likelihood values in the case of trees with very short or
0-length branches.}
\item{\code{PCMBase.Tolerance.Symmetric }}{A double specifying the tolerance in tests
for symmetric matrices. Default 1e-8; see also \code{\link{isSymmetric}}.}
\item{\code{PCMBase.Lmr.mode }}{An integer code specifying the parallel likelihood calculation mode.}
\item{\code{PCMBase.ParamValue.LowerLimit}}{Default lower limit value for parameters, default setting is -10.0.}
\item{\code{PCMBase.ParamValue.LowerLimit.NonNegativeDiagonal}}{Default lower limit value for parameters corresponding to non-negative diagonal elements of matrices, default setting is 0.0.}
\item{\code{PCMBase.ParamValue.UpperLimit}}{Default upper limit value for parameters, default setting is 10.0.}
}
}
\description{
Global options for the PCMBase package
}
\examples{
PCMOptions()
}
