% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcps.curve.R, R/pcpc.curve.calc.R,
%   R/plot.pcpscurve.R, R/print.pcpscurve.R, R/summary.pcpscurve.R
\encoding{UTF-8}
\name{pcps.curve}
\alias{pcps.curve}
\alias{print.pcpscurve}
\alias{summary.pcpscurve}
\alias{plot.pcpscurve}
\alias{pcpc.curve.calc}
\title{Curve of phylogenetic signal at metacommunity level}
\usage{
pcps.curve(
  comm,
  phylodist,
  trait,
  checkdata = TRUE,
  method = "bray",
  squareroot = TRUE,
  ranks = TRUE,
  null.model.ts = FALSE,
  null.model.bm = FALSE,
  tree,
  runs = 99,
  progressbar = FALSE,
  parallel = NULL
)

pcpc.curve.calc(values, vectors, mt)

\method{plot}{pcpscurve}(
  x,
  draw.model = c("none", "ts", "bm"),
  type = "b",
  probs = c(0.025, 0.975),
  col = "black",
  model.col = "black",
  ...
)

\method{print}{pcpscurve}(x, ...)

\method{summary}{pcpscurve}(object, probs = c(0.025, 0.975), ...)
}
\arguments{
\item{comm}{Community data, with species as columns and sampling units as rows. This 
matrix can contain either presence/absence or abundance data.
Alternatively comm can be an object of class metacommunity.data, an alternative
way to set all data.frames/matrices. When you use the class metacommunity.data the arguments
trait and phylodist must not be specified. See details.}

\item{phylodist}{Matrix containing phylogenetic distances between species.}

\item{trait}{Matrix data of species described by traits, with traits as columns and species as rows.}

\item{checkdata}{Logical argument (TRUE or FALSE) to check if species
sequence in the community data follows the same order as the one in the
trait and in the phylodist matrices (Default checkdata = TRUE).}

\item{method}{Dissimilarity index, as accepted by \code{\link{vegdist}} (Default dist = "bray").}

\item{squareroot}{Logical argument (TRUE or FALSE) to specify if use square root of dissimilarity
index (Default squareroot = TRUE).}

\item{ranks}{Logical argument (TRUE or FALSE) to specify if ordinal variables are 
convert to ranks (Default ranks = TRUE).}

\item{null.model.ts}{Logical argument (TRUE or FALSE) to specify if use null model that shuffles
terminal tips across the phylogenetic tree to generate null curves. See details (Default null.model.ts = FALSE).}

\item{null.model.bm}{Logical argument (TRUE or FALSE) to specify if use null model that simulate 
trait evolving under Brownian motion to generate null curves. See details (Default null.model.bm = FALSE).}

\item{tree}{Phylogenetic tree, as phylo object.}

\item{runs}{Number of randomizations.}

\item{progressbar}{Logical argument (TRUE or FALSE) to specify if display a progress bar 
on the R console (Default progressbar = FALSE).}

\item{parallel}{Number of parallel processes or a predefined socket cluster done with parallel package. Tip: use detectCores() (Default parallel = NULL).}

\item{values}{The eigenvalues, relative eigenvalues and cumulative relative eigenvalues returned by \code{\link{pcps}}.}

\item{vectors}{The principal coordinates of phylogenetic structure returned by \code{\link{pcps}}.}

\item{mt}{Matrix containing trait average at community level for one trait.}

\item{x}{An object of class pcpscurve.}

\item{draw.model}{Type of null model to draw; none (none), taxa shuffle (ts), browian motion model (bm).}

\item{type}{Type of the plot to be drawn (Default type = "b").}

\item{probs}{Numeric vector of probabilities used by \code{\link{quantile}}. (Default probs = c(0.025, 0.975)).}

\item{col}{Plot color.}

\item{model.col}{Color of lines of null models.}

\item{...}{Further graphical parameters for points.}

\item{object}{An object of class pcpscurve.}
}
\value{
\item{curve.obs}{The cumulative PCPS eigenvalues and the coefficient of determination.}
\item{curve.null.ts}{The cumulative PCPS eigenvalues and the coefficient of determination for 
each randomization using the taxa shuffle null model.} \item{curve.null.bm}{The cumulative PCPS 
eigenvalues and the coefficient of determination for each randomization using the Brownian motion null model.}
}
\description{
The function estimate the phylogenetic signal at metacommunity level and draws
a representation curve.
}
\details{
The sequence species show up in the community data matrix must be the 
same as they show up in the phylogenetic distance matrix and in traits
matrix. The function \code{\link{organize.pcps}} organizes the data, placing the matrices of 
community and phylogenetic distance and trait in the same order. The function use of function 
organize.pcps is not requered for run the functions, but is recommended. In this way 
the arguments comm and phylodist can be specified them as normal arguments or by passing
them with the object returned by the function \code{\link{organize.pcps}} using, in this
case only the argument comm. Using the object returned by organize.pcps, the comm argument 
is used as an alternative way of entering to set all data.frames/matrices, and therefore 
the arguments phylodist and trait must not be specified.

The PCPS are used, in a sequential manner, as predictors in a linear regression
to model the trait averages across the metacommunity. The curve is drawn as the
percentage of cumulative eigenvalues in the abscissa and as the determination 
coefficient of regressions in the ordinate.

Two null models are available. The first one (ts), the null curves are generated
shuffling terminal tips across the phylogenetic tree, generates a set of random PCPS
and recalculates the curves. The second (bm), the null curves are generated with 
simulate traits evolving under Brownian motion model.
}
\note{
\strong{IMPORTANT}: The sequence of species in the community data matrix
MUST be the same as that in the phylogenetic distance matrix and in traits
matrix. See details and \code{\link{organize.pcps}}.
}
\examples{

\dontrun{
data(flona)
res<-pcps.curve(flona$community, flona$phylo, flona$trait[,1,drop = FALSE], 
       null.model.ts = TRUE, runs = 9)
res
summary(res)
plot(res, draw.model = "ts", type = "b", col = "red")
}

}
\references{
Duarte, L.S. (2011). Phylogenetic habitat filtering influences forest nucleation
in grasslands. Oikos, 120, 208:215.
}
\seealso{
\code{\link{matrix.p}}, \code{\link{pcps}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{PCPS}
