% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/34_DECISION_TREE.R
\name{predict.cdt}
\alias{predict.cdt}
\title{Predict method for custom decision tree}
\usage{
\method{predict}{cdt}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Custom decision tree model (class cdt).}

\item{newdata}{Optionally, a data frame in which to look for variables with which to predict.
If omitted, the fitted predictors are used.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Returns average default rate per leaf.
}
\description{
Predict method for custom decision tree
}
\examples{
#S3 method for class "cdt"
suppressMessages(library(PDtoolkit))
data(loans)
tree.res <- decision.tree(db = loans,
	rf = c("Account Balance", "Duration of Credit (month)"), 
	target = "Creditability",
	min.pct.obs = 0.05,
	min.avg.rate = 0.01,
	p.value = 0.05,
	max.depth = NA,
	monotonicity = TRUE)
str(tree.res)
#predict method - development sample
pred.1 <- predict(object = tree.res, newdata = NULL)
head(pred.1)
auc.model(predictions = pred.1$average, observed = loans$Creditability)
#predict method - new data
set.seed(321)
loans.m <- loans[sample(1:nrow(loans), 500, replace = TRUE), ]
pred.2 <- predict(object = tree.res, newdata = loans.m)
head(pred.2)
auc.model(predictions = pred.2$average, observed = loans.m$Creditability)
}
