% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISR_deprecated.R
\name{phe_isr}
\alias{phe_isr}
\title{Calculate Indirectly Standardised Rates using calculate_ISRate}
\usage{
phe_isr(
  data,
  x,
  n,
  x_ref,
  n_ref,
  refpoptype = "vector",
  type = "full",
  confidence = 0.95,
  multiplier = 1e+05
)
}
\arguments{
\item{data}{data.frame containing the data to be standardised, pre-grouped if
multiple ISRs required; unquoted string; no default}

\item{x}{field name from data containing the observed number of events for
each standardisation category (eg ageband) within each grouping set (eg
area); unquoted string; no default}

\item{n}{field name from data containing the populations for each
standardisation category (eg ageband) within each grouping set (eg area);
unquoted string; no default}

\item{x_ref}{the observed number of events in the reference population for
each standardisation category (eg age band); unquoted string referencing a
numeric vector or field name from data depending on value of refpoptype; no
default}

\item{n_ref}{the reference population for each standardisation category (eg
age band); unquoted string referencing a numeric vector or field name from
data depending on value of refpoptype; no default}

\item{refpoptype}{whether x_ref and n_ref have been specified as vectors or a
field name from data; quoted string "field" or "vector"; default = "vector"}

\item{type}{defines the data and metadata columns to be included in output;
can be "value", "lower", "upper", "standard" (for all data) or "full" (for
all data and metadata); quoted string; default = "full"}

\item{confidence}{the required level of confidence expressed as a number
between 0.9 and 1 or a number between 90 and 100 or can be a vector of 0.95
and 0.998, for example, to output both 95 percent and 99.8 percent percent CIs; numeric;
default 0.95}

\item{multiplier}{the multiplier used to express the final values (eg 100,000
= rate per 100,000); numeric; default 100,000}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

To prevent ambiguity over the ISR acronym, the \code{phe_isr} function has been
replaced with a \code{calculate_ISRate} function. Both functions take the same
parameters and provide identical functionality.  The \code{phe_isr} function will
remain available in the \code{PHEindicatormethods} package until at least December
2022 to allow users time to transfer existing code to use the new
\code{calculate_ISRate} function. Please refer to the \code{calculate_ISRate}
documentation for full support on the use of these functions.
}
\examples{
library(dplyr)
df <- data.frame(indicatorid = rep(c(1234, 5678, 91011, 121314), each = 19 * 2 * 5),
                 year = rep(2006:2010, each = 19 * 2),
                 sex = rep(rep(c("Male", "Female"), each = 19), 5),
                 ageband = rep(c(0,5,10,15,20,25,30,35,40,45,
                                 50,55,60,65,70,75,80,85,90), times = 10),
                 obs = sample(200, 19 * 2 * 5 * 4, replace = TRUE),
                 pop = sample(10000:20000, 19 * 2 * 5 * 4, replace = TRUE))

refdf <- data.frame(refcount = sample(200, 19, replace = TRUE),
                    refpop = sample(10000:20000, 19, replace = TRUE))

## calculate multiple ISRs in single execution
df \%>\%
    group_by(indicatorid, year, sex) \%>\%
    phe_isr(obs, pop, refdf$refcount, refdf$refpop)

## execute without outputting metadata fields
df \%>\%
    group_by(indicatorid, year, sex) \%>\%
    phe_isr(obs, pop, refdf$refcount, refdf$refpop, type="standard", confidence=99.8)

## calculate 95\% and 99.8\% CIs in single execution
df \%>\%
    group_by(indicatorid, year, sex) \%>\%
    phe_isr(obs, pop, refdf$refcount, refdf$refpop, confidence = c(0.95, 0.998))

}
\keyword{internal}
