% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixcoxph.R
\name{fixcoxph}
\alias{fixcoxph}
\title{Remove observations from a proportional hazards regression, and return the fit of the reduced model.}
\usage{
fixcoxph(randdat, xxx, iv, verbose = FALSE)
}
\arguments{
\item{randdat}{A list with at least the component y, representing the Surv() object.  I expect that this will be output from an initial non-convergent regression.}

\item{xxx}{a design matrix for the regression.  I expect that this will be the $x component of the output from an initial non-convergent regression, run with x=TRUE .}

\item{iv}{name of the variable of interest, as a character string}

\item{verbose}{logical flag governing printing.}
}
\value{
Fitted survival analysis regression parameter of class coxph, fitted form data set with observations forcing infinite estimation removed.
}
\description{
This function implements the approximate conditional inferential approach of \insertCite{kz19;textual}{PHInfiniteEstimates} to proportional hazards regression.
}
\examples{
data(breast) # From library coxphf
bcfit<-coxph(Surv(TIME,CENS)~ T+ N+ G+ CD,data=breast,x=TRUE)
\donttest{
fixcoxph(bcfit,bcfit$x,"T",Surv(TIME,CENS)~ T+ N+ G+ CD)
}
}
\references{
\insertRef{kz19}{PHInfiniteEstimates}
}
