% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_classes.R
\docType{class}
\name{estimate.mpin.ecm-class}
\alias{estimate.mpin.ecm-class}
\alias{show,estimate.mpin.ecm-method}
\alias{selectModel}
\alias{selectModel,estimate.mpin.ecm-method}
\alias{getSummary}
\alias{getSummary,estimate.mpin.ecm-method}
\title{MPIN estimation results (ECM)}
\usage{
\S4method{show}{estimate.mpin.ecm}(object)

selectModel(object, criterion)

\S4method{selectModel}{estimate.mpin.ecm}(object, criterion)

getSummary(object)

\S4method{getSummary}{estimate.mpin.ecm}(object)
}
\arguments{
\item{object}{an object of class \code{estimate.mpin.ecm}.}

\item{criterion}{a character string specifying the model selection criterion.
\code{criterion} should take one of these values \verb{\{"BIC", "AIC", "AWE"\}}.
They stand for Bayesian Information Criterion, Akaike Information Criterion,
and Approximate Weight of Evidence, respectively.}
}
\description{
The class \code{estimate.mpin.ecm} is the blueprint of
\code{S4} objects that store the results of the estimation of the \code{MPIN}
model using the Expectation-Conditional Maximization method, as
implemented in the function \code{mpin_ecm()}.
}
\section{Functions}{
\itemize{
\item \code{selectModel,estimate.mpin.ecm-method}: returns the optimal model among
the estimated models, i.e., the model having the lowest information
criterion, provided by the user.

\item \code{getSummary,estimate.mpin.ecm-method}: returns a summary of
the estimation of the \code{MPIN} model using the \code{ECM} algorithm for different
values of the argument \code{layers}. For each estimation, the number of layers,
the \code{MPIN} value, the log-likelihood value, as well as the values of the
different information criteria, namely \code{AIC}, \code{BIC} and \code{AWE} are displayed.
}}

\section{Slots}{

\describe{
\item{\code{success}}{(\code{logical}) returns the value \code{TRUE} when the
estimation has succeeded, \code{FALSE} otherwise.}

\item{\code{errorMessage}}{(\code{character}) returns an error message if the \code{MPIN}
estimation has failed, and is empty otherwise.}

\item{\code{convergent.sets}}{(\code{numeric}) returns the number of initial parameter
sets at which the likelihood maximization converged.}

\item{\code{method}}{(\code{character}) returns the method of estimation, and is equal
to 'Expectation-Conditional Maximization Algorithm'.}

\item{\code{layers}}{(\code{numeric}) returns the number of layers estimated by the
Expectation-Conditional Maximization algorithm, or provided by the user.}

\item{\code{optimal}}{(\code{logical}) returns whether the number of layers used for
the estimation is provided by the user \code{(optimal=FALSE)}, or determined
by the \code{ECM} algorithm \code{(optimal=TRUE)}.}

\item{\code{parameters}}{(\code{list}) returns the list of the maximum likelihood
estimates (\eqn{\alpha}, \eqn{\delta}, \eqn{\mu}, \eb, \es), where
\eqn{\alpha}, \eqn{\delta}, and \eqn{\mu} are numeric vectors of
length \code{layers}.}

\item{\code{aggregates}}{(\code{numeric}) returns an aggregation of information layers'
parameters alongside with \eb and \es. The aggregated parameters are
calculated as follows:
\eqn{\alpha_{agg} = \sum \alpha_j}{}\if{html}{\eqn{\alpha*= \sum
\alpha}\subit{j}} \eqn{\delta_{agg} = \sum \alpha_j \times \delta_j}{}
\if{html}{\eqn{\delta*= \sum \alpha}\subit{j}\eqn{\delta}\subit{j}},
and \eqn{\mu_{agg} = \sum \alpha_j \times \mu_j}{}\if{html}{\eqn{\mu*= \sum
\alpha}\subit{j}\eqn{\mu}\subit{j}}.}

\item{\code{likelihood}}{(\code{numeric}) returns the value of the (log-)likelihood
function evaluated at the optimal set of parameters.}

\item{\code{mpinJ}}{(\code{numeric}) returns the values of the multilayer probability of
informed trading per layer, calculated using the layer-specific estimated
parameters.}

\item{\code{mpin}}{(\code{numeric}) returns the global value of the multilayer probability
of informed trading. It is the sum of the multilayer probabilities of
informed trading per layer stored in the slot \code{mpinJ}.}

\item{\code{mpin.goodbad}}{(\code{list}) returns a list containing a decomposition of
\code{MPIN} into good-news, and bad-news \code{MPIN} components. The decomposition
has been suggested for PIN measure in
\insertCite{Brennan2016;textual}{PINstimation}. The list has four elements:
\code{mpinG}, and \code{mpinB} are the global good-news, and bad-news components of
\code{MPIN}, while \code{mpinGj}, and \code{mpinBj} are two vectors containing  the
good-news (bad-news) components of \code{MPIN} computed per layer.}

\item{\code{dataset}}{(\code{dataframe}) returns the dataset of buys and sells used
in the ECM estimation of the MPIN model.}

\item{\code{initialsets}}{(\code{dataframe}) returns the initial parameter sets used
in the ECM estimation of the MPIN model.}

\item{\code{details}}{(\code{dataframe}) returns a dataframe containing the estimated
parameters of the \code{ECM} method for each initial parameter set.}

\item{\code{models}}{(\code{list}) returns the list of \code{estimate.mpin.ecm} objects
storing the results of estimation using the function \code{mpin_ecm()} for
different values of the argument \code{layers}. It returns \code{NULL} when the
argument \code{layers} of the function \code{mpin_ecm()} take a specific value.}

\item{\code{AIC}}{(\code{numeric}) returns the value of the Akaike Information Criterion
(AIC).}

\item{\code{BIC}}{(\code{numeric}) returns the value of the Bayesian Information Criterion
(BIC).}

\item{\code{AWE}}{(\code{numeric}) returns the value of the Approximate Weight of
Evidence.}

\item{\code{criterion}}{(\code{character}) returns the model selection criterion used to
find the optimal estimate for the \code{MPIN} model. It takes one of these values
\code{'BIC'}, \code{'AIC'}, \code{'AWE'}; which stand for Bayesian Information Criterion,
Akaike Information Criterion, and Approximate Weight of Evidence,
respectively.}

\item{\code{hyperparams}}{(\code{list}) returns the hyperparameters of the \code{ECM} algorithm,
which are \code{minalpha}, \code{maxeval}, \code{tolerance}, and \code{maxlayers}. Check the
details section of \code{mpin_ecm()} to know more about these parameters.}

\item{\code{runningtime}}{(\code{numeric}) returns the running time of the estimation
in seconds.}
}}

