% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_mpin.R
\name{get_posteriors}
\alias{get_posteriors}
\title{Posterior probabilities for PIN and MPIN estimates}
\usage{
get_posteriors(object)
}
\arguments{
\item{object}{(S4 object) an object of type \code{estimate.pin},
\code{estimate.mpin}, or \code{estimate.mpin.ecm}.}
}
\value{
If the argument \code{object} is of type \code{estimate.pin}, returns a dataframe of
three variables \code{post.N}, \code{post.G} and \code{post.B} containing in each row the
posterior probability that a given day is a no-information day (\code{N}),
good-information day (\code{G}), or bad-information day (\code{B}) respectively.

If the argument \code{object} is of type \code{estimate.mpin} or \code{estimate.mpin.ecm},
with \code{J} layers, returns a dataframe of \code{2*J+1} variables \code{Post.N}, and
\code{Post.G[j]} and \code{Post.B[j]} for each layer \code{j} containing in each row the
posterior probability that a given day is a no-information day,
good-information day in layer \code{j} or bad-information day in layer \code{j},
for each layer \code{j} respectively.

If the argument \code{object} is of any other type, an error is returned.
}
\description{
Computes, for each day in the sample, the posterior probability
that the day is a no-information day, good-information day and bad-information
day, respectively (\insertCite{Easley1992;textual}{PINstimation},
\insertCite{Easley1996;textual}{PINstimation},
\insertCite{Ersan2016;textual}{PINstimation}).
}
\examples{
# There is a preloaded quarterly dataset called 'dailytrades' with 60
# observations. Each observation corresponds to a day and contains the
# total number of buyer-initiated trades ('B') and seller-initiated
# trades ('S') on that day. To know more, type ?dailytrades

xdata <- dailytrades

# ------------------------------------------------------------------------ #
# Posterior probabilities for PIN estimates                                #
# ------------------------------------------------------------------------ #

# Estimate PIN using the Ersan and Alici (2016) algorithm and the
# factorization Lin and Ke(2011).

estimate <- pin_ea(xdata, "LK", verbose = FALSE)

# Display the estimated PIN value

estimate@pin

# Store the posterior probabilities in a dataframe variable and display its
# first 6 rows.

modelposteriors <- get_posteriors(estimate)
show(round(head(modelposteriors), 3))

# ------------------------------------------------------------------------ #
# Posterior probabilities for MPIN estimates                               #
# ------------------------------------------------------------------------ #

# Estimate MPIN via the ECM algorithm, assuming that the dataset has 2
# information layers

estimate <- mpin_ecm(xdata, layers = 2, verbose = FALSE)

# Display the estimated Multilayer PIN value

show(estimate@mpin)

# Store the posterior probabilities in a dataframe variable and display its
# first six rows. The posterior probabilities are contained in a dataframe
# with 7 variables: one for no-information days, and two variables for each
# layer, one for good-information days and one for bad-information days.

modelposteriors <- get_posteriors(estimate)
show(round(head(modelposteriors), 3))

}
\references{
\insertAllCited
}
