% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_integrate.R
\name{auc_integrate}
\alias{auc_integrate}
\title{Support function for AUC integration}
\usage{
auc_integrate(
  conc,
  time,
  clast,
  tlast,
  lambda.z,
  interval_method,
  fun_linear,
  fun_log,
  fun_inf
)
}
\arguments{
\item{conc}{Measured concentrations}

\item{time}{Time of the measurement of the concentrations}

\item{clast}{The last concentration above the limit of quantification}

\item{tlast}{Time of last concentration above the limit of quantification
(will be calculated, if not provided)}

\item{lambda.z}{The elimination rate (in units of inverse time) for
extrapolation}

\item{interval_method}{The method for integrating each interval of \code{conc}}

\item{fun_linear}{The function to use for integration of the linear part of
the curve (not required for AUC or AUMC functions)}

\item{fun_log}{The function to use for integration of the logarithmic part of
the curve (if log integration is used; not required for AUC or AUMC
functions)}

\item{fun_inf}{The function to use for extrapolation from the final
measurement to infinite time (not required for AUC or AUMC functions.}
}
\description{
Support function for AUC integration
}
\keyword{Internal}
