% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.classes.R
\name{PKNCAconc}
\alias{PKNCAconc}
\alias{PKNCAconc.data.frame}
\alias{PKNCAconc.default}
\alias{PKNCAconc.tbl_df}
\title{Create a PKNCAconc object}
\usage{
PKNCAconc(data, ...)

\method{PKNCAconc}{default}(data, ...)

\method{PKNCAconc}{tbl_df}(data, ...)

\method{PKNCAconc}{data.frame}(data, formula, subject, labels, units, ...)
}
\arguments{
\item{data}{A data frame with concentration, time, and the groups
defined in \code{formula}.}

\item{...}{Ignored.}

\item{formula}{The formula defining the
\code{concentration~time|groups}}

\item{subject}{The column indicating the subject number (used for
plotting).  If not provided, this defaults to the beginning of the
inner groups: For example with
\code{concentration~time|Study+Subject/Analyte}, the inner groups
start with the first grouping variable before a \code{/},
\code{Subject}.  If there is only one grouping variable, it is
assumed to be the subject (e.g. \code{concentration~time|Subject}),
and if there are multiple grouping variables without a \code{/},
subject is assumed to be the last one.  For single-subject data, it
is assigned as \code{NULL}.}

\item{labels}{(optional) Labels for use when plotting.  They are a
named list where the names correspond to the names in the data
frame and the values are used for xlab and/or ylab as appropriate.}

\item{units}{(optional) Units for use when plotting and calculating
parameters.  Note that unit conversions and simplifications are not
done; the text is used as-is.}
}
\value{
A PKNCAconc object that can be used for automated NCA.
}
\description{
Create a PKNCAconc object
}

