% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNnetworkfamily-class.R
\name{Networkfamily}
\alias{Networkfamily}
\title{An R6 Class to virtually represent a collection of network fits}
\description{
The functions \code{\link[=PLNnetwork]{PLNnetwork()}} and \code{\link[=ZIPLNnetwork]{ZIPLNnetwork()}} both produce an instance of this class, which can be thought of as a vector of \code{\link{PLNnetworkfit}}s \code{\link{ZIPLNfit_sparse}}s (indexed by penalty parameter)

This class comes with a set of methods mostly used to compare
network fits (in terms of goodness of fit) or extract one from
the family (based on penalty parameter and/or goodness of it).
See the documentation for \code{\link[=getBestModel]{getBestModel()}},
\code{\link[=getModel]{getModel()}} and \link[=plot.Networkfamily]{plot()} for the user-facing ones.
}
\seealso{
The functions \code{\link[=PLNnetwork]{PLNnetwork()}}, \code{\link[=ZIPLNnetwork]{ZIPLNnetwork()}} and the classes \code{\link{PLNnetworkfit}}, \code{\link{ZIPLNfit_sparse}}
}
\section{Super class}{
\code{\link[PLNmodels:PLNfamily]{PLNmodels::PLNfamily}} -> \code{Networkfamily}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{penalties}}{the sparsity level of the network in the successively fitted models}

\item{\code{stability_path}}{the stability path of each edge as returned by the stars procedure}

\item{\code{stability}}{mean edge stability along the penalty path}

\item{\code{criteria}}{a data frame with the values of some criteria (variational log-likelihood, (E)BIC, ICL and R2, stability) for the collection of models / fits
BIC, ICL and EBIC are defined so that they are on the same scale as the model log-likelihood, i.e. with the form, loglik - 0.5 penalty}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Networkfamily-new}{\code{Networkfamily$new()}}
\item \href{#method-Networkfamily-optimize}{\code{Networkfamily$optimize()}}
\item \href{#method-Networkfamily-coefficient_path}{\code{Networkfamily$coefficient_path()}}
\item \href{#method-Networkfamily-getBestModel}{\code{Networkfamily$getBestModel()}}
\item \href{#method-Networkfamily-plot}{\code{Networkfamily$plot()}}
\item \href{#method-Networkfamily-plot_stars}{\code{Networkfamily$plot_stars()}}
\item \href{#method-Networkfamily-plot_objective}{\code{Networkfamily$plot_objective()}}
\item \href{#method-Networkfamily-show}{\code{Networkfamily$show()}}
\item \href{#method-Networkfamily-clone}{\code{Networkfamily$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="getModel"><a href='../../PLNmodels/html/PLNfamily.html#method-PLNfamily-getModel'><code>PLNmodels::PLNfamily$getModel()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="postTreatment"><a href='../../PLNmodels/html/PLNfamily.html#method-PLNfamily-postTreatment'><code>PLNmodels::PLNfamily$postTreatment()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="print"><a href='../../PLNmodels/html/PLNfamily.html#method-PLNfamily-print'><code>PLNmodels::PLNfamily$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Networkfamily-new"></a>}}
\if{latex}{\out{\hypertarget{method-Networkfamily-new}{}}}
\subsection{Method \code{new()}}{
Initialize all models in the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Networkfamily$new(penalties, data, control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{penalties}}{a vector of positive real number controlling the level of sparsity of the underlying network.}

\item{\code{data}}{a named list used internally to carry the data matrices}

\item{\code{control}}{a list for controlling the optimization.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Update all network fits in the family with smart starting values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Networkfamily-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-Networkfamily-optimize}{}}}
\subsection{Method \code{optimize()}}{
Call to the C++ optimizer on all models of the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Networkfamily$optimize(data, config)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a named list used internally to carry the data matrices}

\item{\code{config}}{a list for controlling the optimization.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Networkfamily-coefficient_path"></a>}}
\if{latex}{\out{\hypertarget{method-Networkfamily-coefficient_path}{}}}
\subsection{Method \code{coefficient_path()}}{
Extract the regularization path of a \code{\link{Networkfamily}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Networkfamily$coefficient_path(precision = TRUE, corr = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{precision}}{Logical. Should the regularization path be extracted from the precision matrix Omega (\code{TRUE}, default) or from the variance matrix Sigma (\code{FALSE})}

\item{\code{corr}}{Logical. Should the matrix be transformed to (partial) correlation matrix before extraction? Defaults to \code{TRUE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Networkfamily-getBestModel"></a>}}
\if{latex}{\out{\hypertarget{method-Networkfamily-getBestModel}{}}}
\subsection{Method \code{getBestModel()}}{
Extract the best network in the family according to some criteria
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Networkfamily$getBestModel(crit = c("BIC", "EBIC", "StARS"), stability = 0.9)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{crit}}{character. Criterion used to perform the selection. If "StARS" is chosen but \verb{$stability} field is empty, will compute stability path.}

\item{\code{stability}}{Only used for "StARS" criterion. A scalar indicating the target stability (= 1 - 2 beta) at which the network is selected. Default is \code{0.9}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For BIC and EBIC criteria, higher is better.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Networkfamily-plot"></a>}}
\if{latex}{\out{\hypertarget{method-Networkfamily-plot}{}}}
\subsection{Method \code{plot()}}{
Display various outputs (goodness-of-fit criteria, robustness, diagnostic) associated with a collection of network fits (a \code{\link{Networkfamily}})
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Networkfamily$plot(
  criteria = c("loglik", "pen_loglik", "BIC", "EBIC"),
  reverse = FALSE,
  log.x = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{criteria}}{vector of characters. The criteria to plot in \code{c("loglik", "pen_loglik", "BIC", "EBIC")}. Defaults to all of them.}

\item{\code{reverse}}{A logical indicating whether to plot the value of the criteria in the "natural" direction
(loglik - 0.5 penalty) or in the "reverse" direction (-2 loglik + penalty). Default to FALSE, i.e use the
natural direction, on the same scale as the log-likelihood.}

\item{\code{log.x}}{logical: should the x-axis be represented in log-scale? Default is \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{\link{ggplot}} graph
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Networkfamily-plot_stars"></a>}}
\if{latex}{\out{\hypertarget{method-Networkfamily-plot_stars}{}}}
\subsection{Method \code{plot_stars()}}{
Plot stability path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Networkfamily$plot_stars(stability = 0.9, log.x = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{stability}}{scalar: the targeted level of stability using stability selection. Default is \code{0.9}.}

\item{\code{log.x}}{logical: should the x-axis be represented in log-scale? Default is \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{\link{ggplot}} graph
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Networkfamily-plot_objective"></a>}}
\if{latex}{\out{\hypertarget{method-Networkfamily-plot_objective}{}}}
\subsection{Method \code{plot_objective()}}{
Plot objective value of the optimization problem along the penalty path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Networkfamily$plot_objective()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a \code{\link{ggplot}} graph
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Networkfamily-show"></a>}}
\if{latex}{\out{\hypertarget{method-Networkfamily-show}{}}}
\subsection{Method \code{show()}}{
User friendly print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Networkfamily$show()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Networkfamily-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Networkfamily-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Networkfamily$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
