% Generated by roxygen2 (4.0.1): do not edit by hand
\name{opt.penalty.values}
\alias{opt.penalty.values}
\title{Choosing a value for penalty parameters lambdaX and lambdaY for the Sparse Partial Least Squares (SPLS) and Sparse Partial Least Squares-Generalized Linear Model (SPLS-GLM) analyses}
\usage{
opt.penalty.values(X, Y, A, algorithm = NULL, eps, from.value.X, to.value.X,
  from.value.Y, to.value.Y, lambdaY.len, lambdaX.len, ...)
}
\arguments{
\item{X}{A (NxP) predictor matrix}

\item{Y}{A (NxM) response matrix; can also be a vector in the case of the SPLS-GLM}

\item{A}{The number of Partial Least Squares (PLS) components}

\item{algorithm}{Any of the SPLS or SPLS-GLM algorithms ("mod.SPLS", "SPLS.GLM", "SPLS.binomial.GLM")}

\item{eps}{Cut off value for convergence step}

\item{from.value.X}{starting value for lambdaX}

\item{to.value.X}{ending value for lambdaX}

\item{from.value.Y}{starting value for lambdaY}

\item{to.value.Y}{ending value for lambdaY}

\item{lambdaY.len}{length of lambdaY value}

\item{lambdaX.len}{length of lambdaX value}

\item{...}{Other arguments. Currently ignored}
}
\value{
the value of the penalty parameters (lambdaX,lambdaY) having the minimum RMSEP value, as well as the RMSEP values obtained when the lambdaX and lambdaY values were paired together
}
\description{
Gives the value of the penalty parameters (lambdaX,lambdaY) having the minimum RMSEP value.
}
\examples{
if(require(chemometrics))
data(ash, package="chemometrics")
X1 = as.matrix(ash[,10:17], ncol=8)
Y1 = as.matrix(ash$SOT)
colnames(Y1) = paste("SOT")
#choosing a value for the penalty parameters lambdaY and lambdaX for this data
opt.penalty.values(X=scale(X1), Y=scale(Y1), A=2, algorithm=mod.SPLS, eps=1e-5,
from.value.X=0, to.value.X=500, from.value.Y=0, to.value.Y=0, lambdaY.len=1, lambdaX.len=100)
#thus, use lambdaX = 10.10 and lambdaY = 0 for the SPLS analysis of this data

#possum.mat data
if(require(robustbase))
possum.mat
y = as.matrix(possum.mat[,1], ncol=1)
dimnames(y) = list(paste("S", 1:nrow(possum.mat), seq=""), "Diversity")
X = as.matrix(possum.mat[,2:14], ncol=13)
dimnames(X) = list(paste("S", 1:nrow(possum.mat), seq=""), colnames(possum.mat[,2:14]))
#choosing a value for the penalty parameters lambdaY and lambdaX for this data
opt.penalty.values(X=scale(X), Y=scale(y), A=2, algorithm=SPLS.GLM, eps=1e-3,
from.value.X=1, to.value.X=4, from.value.Y=0, to.value.Y=0, lambdaY.len=1, lambdaX.len=100)
#thus, use lambdaY = 0 and lambdaX = 3.3 for the (Poisson) SPLS-GLM analysis of this data

#Pima.tr data
if(require(MASS))
data(Pima.tr, package="MASS")
X = as.matrix(cbind(Pima.tr[,1:7]))
dimnames(X) = list(1:nrow(X), colnames(X))
y = as.matrix(as.numeric(Pima.tr$type)-1, ncol=1)
#0=No and 1=Yes
dimnames(y) = list(1:nrow(y), paste("type"))
#choosing a value for the penalty parameters lambdaY and lambdaX for this data
opt.penalty.values(X=scale(X), Y=scale(y), A=2, algorithm=SPLS.binomial.GLM, eps=1e-3,
from.value.X=0, to.value.X=95, from.value.Y=0, to.value.Y=0, lambdaY.len=1, lambdaX.len=100)
#thus, use lambdaY = 0 and lambdaX = 0.96 for the (Binomial) SPLS-GLM analysis of this data
}
\author{
Opeoluwa F. Oyedele and Sugnet Gardner-Lubbe
}

