% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsim.bw.r
\name{plsim.bw}
\alias{plsim.bw}
\alias{plsim.bw.formula}
\alias{plsim.bw.default}
\alias{bwsel_Core}
\alias{bwsel_new.CrossValidation}
\alias{bwsel_new.default}
\alias{deal_formula}
\alias{summary.pls}
\title{select bandwidth}
\usage{
plsim.bw(\dots)

\method{plsim.bw}{formula}(formula, data, \dots)

\method{plsim.bw}{default}(xdat, zdat, ydat, zeta_i=NULL, bandwidthList=NULL, 
ParmaSelMethod="CrossValidation", K=5, TestRatio=0.1, TargetMethod='plsimest',
lambda=NULL, l1_ratio=NULL, VarSelMethod = "SCAD", MaxStep = 1L, 
verbose=FALSE, seed=0, \dots)
}
\arguments{
\item{\dots}{additional arguments.}

\item{formula}{a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment containing the variables in the model.}

\item{xdat}{input matrix (linear covariates). The model reduces to a single index model when \code{x} is NULL.}

\item{zdat}{input matrix (nonlinear covariates). \code{z} should not be NULL.}

\item{ydat}{input vector (response variable).}

\item{bandwidthList}{vector, candidate bandwidths.}

\item{TargetMethod}{string, optional (default: "plsimest"). 
target method to be selected bandwidth for, which could be "MAVE", "plsimest" and "plsim".}

\item{ParmaSelMethod}{string, optional (default: "CrossValidation"). 
Method to select bandwidth, which could be Cross Validation ("CrossValidation") 
and Simple Validation ("SimpleValidation").}

\item{K}{int, optional (default: 5). The number of folds for Cross Validation.}

\item{TestRatio}{double, optional (default: 0.1). The ratio of test data for Simple Validation.}

\item{zeta_i}{initial coefficients. It could be obtained by the function \code{\link{plsim.ini}}.
\code{zeta_i[1:ncol(z)]} is the initial coefficient vector \eqn{\boldmath{\alpha}_0}, 
and \code{zeta_i[(ncol(z)+1):(ncol(z)+ncol(x))]} is the initial coefficient vector \eqn{\boldmath{\beta}_0}.}

\item{lambda}{the parameter for the function \link{plsim.vs.soft}, default: NULL.}

\item{l1_ratio}{the parameter for the function \link{plsim.vs.soft}, default: NULL.}

\item{VarSelMethod}{the parameter for the function \link{plsim.vs.soft}, default : "SCAD".}

\item{MaxStep}{the parameter for the function \link{plsim.vs.soft}, default: 1.}

\item{verbose}{the parameter for the function \link{plsim.vs.soft}, default: FALSE.}

\item{seed}{int, default: 0.}
}
\value{
\item{bandwidthBest}{selected bandwidth}
\item{mse}{mean square errors corresponding to the \code{bandwidthList} }
}
\description{
Select bandwidth for methods, including MAVE, Profile Least Squares Estimator and 
Penalized Profile Least Squares Estimator by cross validation or simple validation.
}
\examples{

# EXAMPLE 1 (INTERFACE=FORMULA)
# To select bandwidth by cross validation and simple validation. 

n = 50
sigma = 0.1

alpha = matrix(1,2,1)
alpha = alpha/norm(alpha,"2")

beta = matrix(4,1,1)

x = matrix(1,n,1)
z = matrix(runif(n*2),n,2)
y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

# Select bandwidth for profile least squares estimator by cross validation
res_plsimest_cross = plsim.bw(y~x|z,bandwidthList=c(0.02,0.04,0.06,0.08,0.10))

# Select bandwidth for profile least squares estimator by simple validation
res_plsimest_simple = plsim.bw(y~x|z,bandwidthList=c(0.02,0.04,0.06,0.08,0.10),
                            ParmaSelMethod="SimpleValidation")

# Select bandwidth for penalized profile least squares estimator by simple validation
res_plsim_simple = plsim.bw(y~x|z,bandwidthList=c(0.02,0.04,0.06,0.08,0.10),
                         ParmaSelMethod="SimpleValidation",TargetMethod="plsim",lambda=0.01)


# EXAMPLE 2 (INTERFACE=DATA FRAME)
# To select bandwidth by cross validation and simple validation. 

n = 50
sigma = 0.1

alpha = matrix(1,2,1)
alpha = alpha/norm(alpha,"2")

beta = matrix(4,1,1)

x = rep(1,n)
z1 = runif(n)
z2 = runif(n) 
X = data.frame(x)
Z = data.frame(z1,z2)

x = data.matrix(X)
z = data.matrix(Z)
y = 4*((z\%*\%alpha-1/sqrt(2))^2) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

# Select bandwidth for profile least squares estimator by cross validation
res_plsimest_cross = plsim.bw(xdat=X,zdat=Z,ydat=y,bandwidthList=c(0.02,0.04,0.06,0.08,0.10))

# Select bandwidth for profile least squares estimator by simple validation
res_plsimest_simple = plsim.bw(xdat=X,zdat=Z,ydat=y,bandwidthList=c(0.02,0.04,0.06,0.08,0.10),
                            ParmaSelMethod="SimpleValidation")

# Select bandwidth for penalized profile least squares estimator by simple validation
res_plsim_simple = plsim.bw(xdat=X,zdat=Z,ydat=y,bandwidthList=c(0.02,0.04,0.06,0.08,0.10),
                         ParmaSelMethod="SimpleValidation",TargetMethod="plsim",lambda=0.01)
                                 
}
