% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mackWolfeTest.R
\name{mackWolfeTest}
\alias{mackWolfeTest}
\alias{mackWolfeTest.default}
\alias{mackWolfeTest.formula}
\title{Mack-Wolfe Test for Umbrella Alternatives}
\usage{
mackWolfeTest(x, ...)

\method{mackWolfeTest}{default}(x, g, p = NULL, nperm = 1000, ...)

\method{mackWolfeTest}{formula}(formula, data, subset, na.action, p = NULL, nperm = 1000, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{p}{the a-priori known peak as an ordinal number of the treatment
group including the zero dose level, i.e. \eqn{p = \{1, \ldots, k\}}.
Defaults to \code{NULL}.}

\item{nperm}{number of permutations for the assymptotic permutation test.
Defaults to \code{1000}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated quantile of the test statistic.}
 \item{p.value}{the p-value for the test.}
 \item{parameter}{the parameters of the test statistic, if any.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Mack-Wolfe non-parametric test for umbrella alternatives.
}
\details{
In dose-finding studies one may assume an increasing treatment
effect with increasing dose level. However, the test
subject may actually succumb to toxic effects at high doses,
which leads to decresing treatment effects.

The scope of the Mack-Wolfe Test is to test for umbrella alternatives
for either a known or unknown point \eqn{p} (i.e. dose-level),
where the peak (umbrella point) is present.

H\eqn{_i: \theta_0 = \theta_i = \ldots = \theta_k} is tested
against the alternative A\eqn{_i: \theta_1 \le \ldots \theta_p \ge
\theta_k} for some \eqn{p}, with at least one strict inequality.

If \code{p = NULL} (peak unknown), the upper-tail \eqn{p}-value is computed
via an asymptotic bootstrap permutation test.

If an integer value for \code{p} is given (peak known), the
upper-tail \eqn{p}-value is computed from the standard normal
distribution (\code{\link{pnorm}}).
}
\note{
One may increase the number of permutations to e.g. \code{nperm = 10000}
in order to get more precise p-values. However, this will be on
the expense of computational time.
}
\examples{
## Example from Table 6.10 of Hollander and Wolfe (1999).
## Plates with Salmonella bacteria of strain TA98 were exposed to
## various doses of Acid Red 114 (in mu g / ml).
## The data are the numbers of visible revertant colonies on 12 plates.
## Assume a peak at D333 (i.e. p = 3).
x <- c(22, 23, 35, 60, 59, 54, 98, 78, 50, 60, 82, 59, 22, 44,
  33, 23, 21, 25)
g <- as.ordered(rep(c(0, 100, 333, 1000, 3333, 10000), each=3))
plot(x ~ g)
mackWolfeTest(x=x, g=g, p=3)

}
\references{
Chen, I. Y. (1991) Notes on the Mack-Wolfe and Chen-Wolfe
Tests for Umbrella Alternatives, \emph{Biom. J.} \bold{33}, 281--290.

Mack, G. A., Wolfe, D. A. (1981) K-sample rank tests for
umbrella alternatives, \emph{J. Amer. Statist. Assoc.} \bold{76}, 175--181.
}
\seealso{
\code{\link{pnorm}}, \code{\link{sample}}.
}
\concept{kruskalranks}
\concept{umbrellatest}
\keyword{htest}
\keyword{nonparametric}
