% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwsTrendTest.R
\name{bwsTrendTest}
\alias{bwsTrendTest}
\alias{bwsTrendTest.default}
\alias{bwsTrendTest.formula}
\title{Testing against Ordered Alternatives (Murakami's BWS Trend Test)}
\usage{
bwsTrendTest(x, ...)

\method{bwsTrendTest}{default}(x, g, nperm = 1000, ...)

\method{bwsTrendTest}{formula}(formula, data, subset, na.action, nperm = 1000, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{nperm}{number of permutations for the assymptotic permutation test.
Defaults to \code{1000}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated quantile of the test statistic.}
 \item{p.value}{the p-value for the test.}
 \item{parameter}{the parameters of the test statistic, if any.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Murakami's modified Baumgartner-Weiß-Schindler
test for testing against ordered alternatives.
}
\details{
The null hypothesis, H\eqn{_0: F_1(u) = F_2(u) = \ldots = F_k(u) ~~ u \in R}
is tested against a simple order hypothesis,
H\eqn{_\mathrm{A}: F_1(u) \le F_2(u) \le \ldots \le
F_k(u),~F_1(u) < F_k(u), ~~ u \in R}.

The p-values are estimated through an assymptotic boot-strap method
using the function \code{\link{sample}}.
}
\note{
One may increase the number of permutations to e.g. \code{nperm = 10000}
in order to get more precise p-values. However, this will be on
the expense of computational time.

Factor labels for \code{g} must be assigned in such a way,
that they can be increasingly ordered from zero-dose
control to the highest dose level, e.g. integers {0, 1, 2, ..., k} or
letters {a, b, c, ...}. Otherwise the function may not
select the correct values for intended zero-dose control.

It is safer, to i) label the factor levels as given above,
and to ii) sort the data according to increasing dose-levels
prior to call the function (see \code{\link{order}}, \code{\link{factor}}).
}
\examples{
## Example from Sachs (1997, p. 402)
x <- c(106, 114, 116, 127, 145,
       110, 125, 143, 148, 151,
       136, 139, 149, 160, 174)
g <- gl(3,5)
levels(g) <- c("A", "B", "C")

## Chacko's test
chackoTest(x, g)

## Cuzick's test
cuzickTest(x, g)

## Johnson-Mehrotra test
johnsonTest(x, g)

## Jonckheere-Terpstra test
jonckheereTest(x, g)

## Le's test
leTest(x, g)

## Spearman type test
spearmanTest(x, g)

## Murakami's BWS trend test
bwsTrendTest(x, g)

## Fligner-Wolfe test
flignerWolfeTest(x, g)

## Shan-Young-Kang test
shanTest(x, g)

}
\references{
Baumgartner, W., Weiss, P., Schindler, H. (1998) A nonparametric test for the
general two-sample problem, \emph{Biometrics} \bold{54}, 1129--1135.

Murakami, H. (2006) K-sample rank test based on modified Baumgartner statistic and its power
comparison, \emph{J. Jpn. Comp. Statist.} \bold{19}, 1--13.

Neuhäuser, M. (2001) One-side two-sample and trend tests based on a modified
Baumgartner-Weiss-Schindler statistic.
\emph{Journal of Nonparametric Statistics} \bold{13}, 729--739.
}
\seealso{
\code{\link{sample}}, \code{\link{bwsAllPairsTest}},
\code{\link{bwsManyOneTest}}.

\code{\link{kruskalTest}} and \code{\link{shirleyWilliamsTest}}
of the package \pkg{PMCMRplus},
\code{\link[stats]{kruskal.test}} of the library \pkg{stats}.
}
\concept{trendtest}
\keyword{htest}
\keyword{nonparametric}
