% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duncanTest.R
\name{duncanTest}
\alias{duncanTest}
\alias{duncanTest.default}
\alias{duncanTest.formula}
\alias{duncanTest.aov}
\title{Duncan's Multiple Range Test}
\usage{
duncanTest(x, ...)

\method{duncanTest}{default}(x, g, ...)

\method{duncanTest}{formula}(formula, data, subset, na.action, ...)

\method{duncanTest}{aov}(x, ...)
}
\arguments{
\item{x}{a numeric vector of data values, a list of numeric data
vectors or a fitted model object, usually an \link[stats]{aov} fit.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
\item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Duncan's all-pairs comparisons test for normally distributed
data with equal group variances.
}
\details{
For all-pairs comparisons in an one-factorial layout
with normally distributed residuals and equal variances
Duncan's multiple range test can be performed.
Let \eqn{X_{ij}} denote a continuous random variable
with the \eqn{j}-the realization (\eqn{1 \le j \le n_i})
in the \eqn{i}-th group (\eqn{1 \le i \le k}). Furthermore, the total
sample size is \eqn{N = \sum_{i=1}^k n_i}. A total of \eqn{m = k(k-1)/2}
hypotheses can be tested: The null hypothesis is
H\eqn{_{ij}: \mu_i = \mu_j ~~ (i \ne j)} is tested against the alternative
A\eqn{_{ij}: \mu_i \ne \mu_j} (two-tailed). Duncan's all-pairs test
statistics are given by

\deqn{
 t_{(i)(j)} \frac{\bar{X}_{(i)} - \bar{X}_{(j)}}
 {s_{\mathrm{in}} \left(r\right)^{1/2}}, ~~
 (i < j)
}{%
 SEE PDF
}

with \eqn{s^2_{\mathrm{in}}} the within-group ANOVA variance,
\eqn{r = k / \sum_{i=1}^k n_i} and \eqn{\bar{X}_{(i)}} the increasingly
ordered means \eqn{1 \le i \le k}.
The null hypothesis is rejected if

\deqn{
 \mathrm{Pr} \left\{ |t_{(i)(j)}| \ge q_{vm'\alpha'} | \mathrm{H} \right\}_{(i)(j)} = \alpha' =
 \min \left\{1,~ 1 - (1 - \alpha)^{(1 / (m' - 1))} \right\},
}{%
 SEE PDF
}

with \eqn{v = N - k} degree of freedom, the range
\eqn{m' = 1 + |i - j|} and \eqn{\alpha'} the Bonferroni adjusted
alpha-error. The p-values are computed
from the \code{\link[stats]{Tukey}} distribution.
}
\examples{
fit <- aov(weight ~ feed, chickwts)
shapiro.test(residuals(fit))
bartlett.test(weight ~ feed, chickwts)
anova(fit)

## also works with fitted objects of class aov
res <- duncanTest(fit)
summary(res)
summaryGroup(res)
}
\references{
Duncan, D. B. (1955) Multiple range and multiple F tests,
\emph{Biometrics} \bold{11}, 1--42.
}
\seealso{
\code{\link[stats]{Tukey}}, \code{\link[stats]{TukeyHSD}} \code{\link{tukeyTest}}
}
\concept{parametric}
\keyword{htest}
