% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_sample_sizes.R
\name{effective_sample_sizes}
\alias{effective_sample_sizes}
\title{Approximate Effective Sample Sizes}
\usage{
effective_sample_sizes(
  sample_sizes_raw = NULL,
  Nt_raw = NULL,
  Nc_raw = NULL,
  cluster_size = 22,
  icc = 0.22
)
}
\arguments{
\item{sample_sizes_raw}{Vector of the raw total study sample size(s).}

\item{Nt_raw}{Vector of raw treatment group sample size(s).}

\item{Nc_raw}{Vector of raw control group sample size(s).}

\item{cluster_size}{Average cluster size (Default = 22, a common class size in education research studies).}

\item{icc}{Assumed intra-class correlation (Default = 0.22, the average ICC value in Hedges & Hedberg (2007) unconditional models)}
}
\value{
A vector of effective sample sizes, adjusted for cluster-dependence.
}
\description{
Approximate Effective Sample Sizes
}
\details{
\code{N_j/DE}
}
\examples{
sample_sizes <- sample(50:1000, 50, replace = TRUE)
effective_sample_sizes(
  sample_sizes_raw = sample_sizes,
  cluster_size = 20,
  icc = 0.15
)


}
