% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIfun.R
\name{pi.ctplot}
\alias{pi.ctplot}
\title{Heatmap/Contour Plot for Assessing Power of the CQA PPQ Plan Using Prediction Interval.}
\usage{
pi.ctplot(attr.name, attr.unit, Llim, Ulim, mu, sigma, n, n.batch, alpha, test.point)
}
\arguments{
\item{attr.name}{user-defined attribute name for PPQ assessment}

\item{attr.unit}{user-defined attribute unit}

\item{Llim}{lower specification limit}

\item{Ulim}{upper specification limit}

\item{mu}{hypothetical mean of the attribute}

\item{sigma}{hypothetical standard deviation of the attribute}

\item{n}{sample size (number of locations) per batch}

\item{n.batch}{number of batches for passing PPQ during validation}

\item{alpha}{significant level for constructing the prediction interval.}

\item{test.point}{(optional) actual process data points for testing whether the processes pass PPQ}
}
\value{
Heatmap (or Countour Plot) for PPQ Assessment.
}
\description{
The function for plotting the heatmap to evaluate the PPQ plan based on the specification test, given lower and upper specification limits.
}
\examples{
\dontrun{
## Example verifying simulation resutls in the textbook page 249
mu <- seq(95, 105, 0.1)
sigma <- seq(0.2, 3.5, 0.1)
pi.ctplot(attr.name = "Composite Assay", attr.unit = "\%LC",
mu = mu, sigma = sigma, Llim=95, Ulim=105)
mu <- seq(90, 110, 0.5)
pi.ctplot(attr.name = "Composite Assay", attr.unit = "\%LC",
mu = mu, sigma = sigma, Llim=90, Ulim=110)

mu <- seq(95,105,0.1)
sigma <- seq(0.1,2.5,0.1)
pi.ctplot(attr.name = "Sterile Concentration Assay", attr.unit = "\%",
mu = mu, sigma = sigma, Llim=95, Ulim=105)
test <- data.frame(mean=c(97,98.3,102.5), sd=c(0.55, 1.5, 1.2))
pi.ctplot(attr.name = "Sterile Concentration Assay", attr.unit = "\%", Llim=95, Ulim=105,
mu = mu, sigma = sigma, test.point=test)
}
}
\references{
Burdick, R. K., LeBlond, D. J., Pfahler, L. B., Quiroz, J., Sidor, L., Vukovinsky, K., & Zhang, L. (2017).
Statistical Applications for Chemistry, Manufacturing and Controls (CMC) in the Pharmaceutical Industry.
\emph{Springer}.
}
\seealso{
\code{pi.pp} and \code{pi.occurve}.
}
\author{
Yalin Zhu
}
