% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptprior.plot.R
\name{priorppt.plot}
\alias{priorppt.plot}
\title{Plot method for prior projected Polya tree}
\usage{
priorppt.plot(priorppt.circ, n.path="all",
plot.type = c("circle", "line", "summary"),control.circular = list(),
shrink=1, tol = 0.04,ylim)
}
\arguments{
\item{priorppt.circ}{object returned by \code{dsimpriorppt} function.}

\item{n.path}{"all" plots all the simulated paths or numeric atomic vector indicates the simulation path of the priorppt.circ object that will be plot.}

\item{plot.type}{type of plot to be drawn:
"circle" for circular plot,
"line" for linear plot and
"summary" for boxplot of mean direction and concentration.}

\item{control.circular}{attributes of circular object in order to draw the circle.See \code{\link[circular]{circular}}.}

\item{shrink}{parameter that controls the size of the plotted circle. Default is 1. Larger values shrink the circle, while smaller values enlarge the circle.}

\item{tol}{proportion of white space at the margins of plot.}

\item{ylim}{range to be encompassed by "y" axis.}
}
\value{
Circular plot of simulated paths when plot.type = "circle". Linear plot of simulated paths for plot.type = "line".
Boxplot of mean direction and concentration for plot.type = "summary"
}
\description{
Plots density paths of simulated prior projected Polya tree, mean direction and concentration.
}
\examples{
z <- dsimpriorppt(mu = c(0,1), nsim = 5, units = "degrees")
priorppt.plot(z, plot.type = "circle",shrink =0.0071, tol = 3.9)
priorppt.plot(z, plot.type = "line",shrink =0.0071, tol = 3.9)
priorppt.plot(z, plot.type = "summary",shrink =0.0071, tol = 3.9)

}
\seealso{
\link[base]{plot}, \code{\link[circular]{plot.density.circular}}
}
