% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baggtree.R
\name{baggtree}
\alias{baggtree}
\title{For each bootstrap sample grow a projection pursuit tree (PPtree object).}
\usage{
baggtree(data, class, m = 500, PPmethod = "LDA", lambda = 0.1,
  size.p = 1, parallel = FALSE, cores = 2)
}
\arguments{
\item{data}{Data frame with the complete data set.}

\item{class}{A character with the name of the class variable.}

\item{m}{is the number of bootstrap replicates, this corresponds with the number of trees to grow. To ensure that each observation is predicted a few times we have to select this number no too small. \code{m = 500} is by default.}

\item{PPmethod}{is the projection pursuit index to be optimized, options LDA or PDA, by default it is LDA.}

\item{lambda}{a parameter for PDA index}

\item{size.p}{proportion of random sample variables in each split.}

\item{parallel}{logical condition, if it is TRUE then  parallelize the function}

\item{cores}{number of cores used in the parallelization}
}
\value{
data frame with trees_pp output for all the bootstraps samples.
}
\description{
For each bootstrap sample grow a projection pursuit tree (PPtree object).
}
\examples{
#crab data set
crab.trees <- baggtree(data = crab, class = 'Type',
m =  200, PPmethod = 'LDA', lambda = .1, size.p = 0.5 , parallel = TRUE, cores = 2)
str(crab.trees, max.level = 1)

}
