% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smm.R
\name{smm}
\alias{smm}
\title{Second Moment Analysis.}
\usage{
smm(mean, var, cor_mat = NULL)
}
\arguments{
\item{mean}{The mean vector.}

\item{var}{The variance vector.}

\item{cor_mat}{The correlation matrix.}
}
\value{
The function returns a list of the total mean, variance, and standard deviation for the project.
}
\description{
Second Moment Analysis.
}
\examples{
mean <- c(10, 15, 20)
var <- c(4, 9, 16)
cor_mat <- matrix(c(
  1, 0.5, 0.3,
  0.5, 1, 0.4,
  0.3, 0.4, 1
), nrow = 3, byrow = TRUE)
result <- smm(mean, var, cor_mat)
print(result)
}
