\name{predict.PRSP}

\alias{predict}

\alias{predict.PRSP}

\title{Predict Function}

\description{
  S3 generic predict function to predict the box membership and box vertices 
  on an independent set from a \code{PRSP} object trained by a SBH model.
}

\usage{
  \method{predict}{PRSP}(object, newdata, steps, na.action = na.omit, ...)
}

\arguments{
  \item{object}{
    Object of class \code{PRSP} as generated by the main function \code{\link[PRIMsrc]{sbh}}.
  }
  \item{newdata}{
    An object containing the new input data: either a numeric matrix or numeric vector.
    A vector will be transformed to a (\#sample x 1) matrix.
  }
  \item{steps}{
    \code{Integer} \code{vector}. Vector of peeling steps at which to predict the box memberships and box vertices. 
    Defaults to the last peeling step only.
  }
  \item{na.action}{
    A function to specify the action to be taken if NAs are found.
    The default action is na.omit, which leads to rejection of incomplete cases.
  }
 \item{\dots}{
    Further generic arguments passed to the predict function.
  }
}

\value{
  \code{List} containing the following 2 fields:
    \item{boxind}{\code{Logical} \code{matrix} of predicted box membership indicator (columns) by peeling steps (rows).
    TRUE = in-box, FALSE = out-of-box.}
    \item{vertices}{\code{List} of size the number of chosen peeling steps where each entry is a \code{numeric} \code{matrix} of 
    predicted box vertices: lower and upper bounds (rows) by covariate (columns).}
}

\references{
    \itemize{
        \item Dazard J-E., Choe M., LeBlanc M. and Rao J.S. (2015).
              "\emph{Cross-validation and Peeling Strategies for Survival Bump Hunting using Recursive Peeling Methods.}"
              (Submitted).
        \item Dazard J-E., Choe M., LeBlanc M. and Rao J.S. (2014).
              "\emph{Cross-Validation of Survival Bump Hunting by Recursive Peeling Methods.}"
              In JSM Proceedings, Survival Methods for Risk Estimation/Prediction Section. Boston, MA, USA.
              American Statistical Association IMS - JSM, p. 3366-3380.
        \item Dazard J-E. and J. S. Rao (2010).
              "\emph{Local Sparse Bump Hunting.}"
              J. Comp Graph. Statistics, 19(4):900-92.
    }
}

\author{
    \itemize{
        \item "Jean-Eudes Dazard, Ph.D." \email{jxd101@case.edu}
        \item "Michael Choe, M.D." \email{mjc206@case.edu}
        \item "Michael LeBlanc, Ph.D." \email{mleblanc@fhcrc.org}
        \item "Alberto Santana, MBA." \email{ahs4@case.edu}
    }
    Maintainer: "Jean-Eudes Dazard, Ph.D." \email{jxd101@case.edu}

    Acknowledgments: This project was partially funded by the National Institutes of Health
    NIH - National Cancer Institute (R01-CA160593) to J-E. Dazard and J.S. Rao.
}

\note{
  End-user predict function.
}

\keyword{Exploratory Survival/Risk Analysis}
\keyword{Survival/Risk Estimation & Prediction}
\keyword{Non-Parametric Method}
\keyword{Cross-Validation}
\keyword{Bump Hunting}
\keyword{Rule-Induction Method}
