% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_Spearman.R
\name{partial_Spearman}
\alias{partial_Spearman}
\title{Partial Spearman's Rank Correlation}
\usage{
partial_Spearman(
  formula,
  data,
  fit.x = "orm",
  fit.y = "orm",
  link.x = c("logit", "probit", "cloglog", "loglog", "cauchit", "logistic"),
  link.y = c("logit", "probit", "cloglog", "loglog", "cauchit", "logistic"),
  subset,
  na.action = getOption("na.action"),
  fisher = TRUE,
  conf.int = 0.95
)
}
\arguments{
\item{formula}{an object of class \code{\link{Formula}} (or one
that can be coerced to that class): a symbolic description of the
model to be fitted.  The details of model specification are given
under \sQuote{Details}.}

\item{data}{an optional data frame, list or environment (or object
coercible by \code{\link{as.data.frame}} to a data frame)
containing the variables in the model.  If not found in
\code{data}, the variables are taken from
\code{environment(formula)}, typically the environment from which
\code{partial_Spearman} is called.}

\item{fit.x, fit.y}{the fitting functions used for the models of X or Y on Z.
The default function is \samp{orm}, which fits cumulative probability models for continuous or discrete ordinal variables. Other options include \samp{lm}, which fits linear regression models and obtains the probability-scale residuals by assuming normality;
\samp{lm.emp}, which fits linear regression models and obtains the probability-scale residuals by empirical ranking;
\samp{poisson}, which fits Poisson models for count variables; \samp{nb}, which fits negative binomial models for count variables; and \samp{logistic}, which fits logistic regression models for binary variables.}

\item{link.x, link.y}{the link family to be used for the ordinal model of
\var{X} on \var{Z}.  Defaults to \samp{logit}. Other options are
\samp{probit}, \samp{cloglog}, \samp{loglog}, \samp{cauchit} and \samp{logistic} (equivalent with \samp{logit}). Used only when
\samp{fit.x} is \samp{orm}.}

\item{subset}{an optional vector specifying a subset of
observations to be used in the fitting process.}

\item{na.action}{action to take when \code{NA} present in data.}

\item{fisher}{logical indicating whether to apply fisher transformation to compute confidence intervals and p-values for the correlation.}

\item{conf.int}{numeric specifying confidence interval coverage.}
}
\value{
object of \samp{partial_Spearman} class.
}
\description{
\code{partial_Spearman} computes the partial Spearman's rank correlation between variable \var{X} and variable \var{Y} adjusting for other variables, \var{Z}.
The basic approach involves fitting a specified model of \var{X} on \var{Z}, a specified model of \var{Y} on \var{Z}, obtaining the probability-scale residuals from both models, and then calculating their Pearson's correlation.
\var{X} and \var{Y} can be any orderable variables, including continuous or discrete variables.
By default, \code{partial_Spearman} uses cumulative probability models (also referred as cumulative link models in literature) for both \var{X} on \var{Z} and \var{Y} on \var{Z} to preserve the rank-based nature of Spearman's correlation, since the model fit of cumulative probability models only depends on the order information of variables. However, for some specific types of variables, options of fitting parametric models are also available. See details in fit.x and fit.y
}
\details{
To compute the partial Spearman's rank correlation between \var{X} and \var{Y} adjusting for \var{Z}, \samp{formula} is specified as \code{\var{X} | \var{Y} ~ \var{Z}}.
This indicates that models of \code{\var{X} ~ \var{Z}} and
\code{\var{Y} ~ \var{Z}} will be fit.
}
\examples{
data(PResidData)
#### fitting cumulative probability models for both Y and W
partial_Spearman(c|w ~ z,data=PResidData)
#### fitting a cumulative probability model for W and a poisson model for c
partial_Spearman(c|w~z, fit.x="poisson",data=PResidData)
partial_Spearman(c|w~z, fit.x="poisson", fit.y="lm.emp", data=PResidData )
}
\references{
Li C and Shepherd BE (2012)
A new residual for ordinal outcomes.
\emph{Biometrika}. \bold{99}: 473--480.

Shepherd BE, Li C, Liu Q (2016)
Probability-scale residuals for continuous, discrete, and censored data.
\emph{The Canadian Jouranl of Statistics}. \bold{44}:463--476.

Liu Q, Shepherd BE, Wanga V, Li C (2018)
Covariate-Adjusted Spearman's Rank Correlation with Probability-Scale Residuals.
\emph{Biometrics}. \bold{74}:595--605.
}
\seealso{
\code{\link{print.partial_Spearman}}
}
