% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSPMevodyn.R
\name{PSPMevodyn}
\alias{PSPMevodyn}
\title{Evolutionary dynamics for a structured population model computed following the canonical equation}
\usage{
PSPMevodyn(modelname = NULL, startpoint = NULL, curvepars = NULL,
  evopars = NULL, covars = NULL, parameters = NULL, options = NULL,
  clean = FALSE, force = FALSE, debug = FALSE, silent = FALSE)
}
\arguments{
\item{modelname}{(string, required)
\preformatted{}
              Basename of the file with the model specification. The file
              should have an extension ".h". For example, the model "PNAS2002"
              is specified in the file "PNAS2002.h". If the model is specified 
              in R include the .R extension explicitly, i.e. specify the model
              name as "PNAS2002.R"}

\item{startpoint}{(row vector, required)
\preformatted{}
              The initial point from which to start the simulation of the dynamics over
              evolutionary time, including the initial values of the evolving parameters}

\item{curvepars}{(row vector of length 2, required)
\preformatted{}
              Vector of length 2 specifying:

\preformatted{}
              \verb{curvepars[1]}: the maximum step size in evolutionary time during
                            the integration of the canonical equation
\preformatted{}
              \verb{curvepars[2]}: the maximum evolutionary time at which to stop
                            the integration of the canonical equation}

\item{evopars}{(row vector of length n*4, required)
\preformatted{}
              Vector of length n*4 specifying:

\preformatted{}
              \verb{evopars[1]}: the index of the structured population whose
                           life history is influenced by the first evolving
                           parameter
\preformatted{}
              \verb{evopars[2]}: the index of the first evolution parameter
                           (in case the model is specified in R, this can be
                           a string with the name of the parameter as specified
                           in the variable 'DefaultParameters')
\preformatted{}
              \verb{evopars[3]}: lower threshold, below which value of the
                          first evolution parameter the computation stops
\preformatted{}
              \verb{evopars[4]}: upper threshold, above which value of the
                          first evolution parameter the computation stops
\preformatted{}
              ......
\preformatted{}
              \verb{evopars[n*4-3]}: the index of the structured population whose
                               life history is influenced by the last evolving
                               parameter
\preformatted{}
              \verb{evopars[n*4-2]}: the index of the last evolution parameter
                               (in case the model is specified in R, this can be
                               a string with the name of the parameter as specified
                               in the variable 'DefaultParameters')
\preformatted{}
              \verb{evopars[n*4-1]}: lower threshold, below which value of the
                               last evolution parameter the computation stops
\preformatted{}
              \verb{evopars[n*4]}:   upper threshold, above which value of the
                               last evolution parameter the computation stops}

\item{covars}{(row vector or matrix, optional, can be left equal to its default NULL)
\preformatted{}
              Vector of length N*N or NxN matrix, where N is the number of evolving
              parameters. The vector or matrix elements specify the values of the
              covariance matrix in the selection gradients. Vectors of other lengths,
              including an empty vector will be ignored.}

\item{parameters}{(row vector, optional, can be left equal to its default NULL)
\preformatted{}
              Vector of length PARAMETER_NR (set in the model program
              file), specifying the values for the model parameters to
              use in the computation. Vectors of other lengths, including
              an empty vector will be ignored.}

\item{options}{(row vector of strings, optional, can be left equal to its default NULL)
\preformatted{}
              Vector with pairs of strings, consisting of an option name and a value (for
              example c("popZE", "1")) or single options (i.e. c("test")).
              Possible option names and their values are:

\preformatted{}
              \verb{"envZE", "<index>"}: Index of environment variable in
                                   trivial equilibrium (can be used
                                   multiple times)
\preformatted{}
              \verb{"popZE", "<index>"}: Index of structured population in
                                   trivial equilibrium (can be used
                                   multiple times)
\preformatted{}
              \verb{"isort", "<index>"}: Index of i-state variable to use as
                                   ruling variable for sorting the
                                   structured populations
\preformatted{}
              \verb{"report", "<value>"}: Interval between consecutive output of 
                                   computed points to the console ( >= 1). 
                                   Minimum value of 1 implies output of every 
                                   point
\preformatted{}
              \verb{"test"}: Perform only a single integration over
                                   the life history, reporting dynamics
                                   of survival, R0, i-state and
                                   interaction variables}

\item{clean}{(Boolean, optional argument)
\preformatted{}
              Specify clean = TRUE as argument to remove all the result files
              of the model before the computation}

\item{force}{(Boolean, optional argument)
\preformatted{}
              Specify force = TRUE as argument to force a rebuilding of the model
              before the computation}

\item{debug}{(Boolean, optional argument)
\preformatted{}
              Specify debug = TRUE as argument to compile the model in verbose
              mode and with debugging flag set}

\item{silent}{(Boolean, optional argument)
\preformatted{}
              Specify silent = TRUE as argument to suppress reporting of compilation
              commands and results on the console}
}
\value{
The output is a list containing the following elements:

\preformatted{}
  \verb{curvepoints}: Matrix with output for all computed points along the curve

\preformatted{}
  \verb{curvedesc}:   Column vector with strings, summarizing the numerical details
               of the computed curve (i.e., initial point, parameter values,
               numerical settings used)
}
\description{
\code{PSPMevodyn} computes the dynamics of a physiologically structured population model
over evolutionary time for an arbitrary number of evolving parameters. The
evolutionary trajectory of these evolving parameters is determined by the
canonical equation of Adaptive Dynamics, which is solved using a simple
Euler integration scheme.
}
\details{
output <- PSPMevodyn(modelname = NULL, startpoint = NULL, curvepars = NULL,
                       evopars = NULL, covars = NULL, parameters = NULL,
                       options = NULL, clean = FALSE, force = FALSE,
                       debug = FALSE, silent = FALSE)
}
\examples{
PSPMevodyn("Indet_growth", c(0.22, 0.03554, 1.0), c(0.05, 2), 
            c(0, 6, 0.5, 1.5))

}
