% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_ContUserScore}
\alias{plot_ContUserScore}
\title{Plot Andromeda score distribution of contaminant peptide vs. matrix peptides.}
\usage{
plot_ContUserScore(data, raw.file, score)
}
\arguments{
\item{data}{A data.frame with columns 'x', 'y', 'condition'}

\item{raw.file}{Name of Raw file for which the data is displayed (will become part of the plot title)}

\item{score}{Score of how distinct the distributions are (will become part of the title)}
}
\value{
GGplot object
}
\description{
The data is expected to be an ECDF already, x being the Andromeda score, y being the culmulative probability.
The Score is the probability of a Kolm.-Smirnoff test that the contaminant scores are larger (i.e.
large p-values indicate true contamination).
You will only see this plot if the %-threshold (YAML config) was reached. This is a saveguard against false-positive,
but high-scoring contaminant peptides, which would erroneously give you a large p-value and make you believe
your sample is contaminated although that's not the case.
}
\examples{

 data = data.frame(x = 10:60,
                   y = c(seq(0,1,length=51), seq(0.1, 1, length=51)), 
                   condition = rep(c("sample","contaminant"), each=51))
 plot_ContUserScore(data, 'test file', 0.96)

}
