% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilenameMapper.R
\docType{class}
\name{FilenameMapper-class}
\alias{FilenameMapper-class}
\alias{FilenameMapper}
\title{Make sure to call $readMappingFile(some_file) if you want to support a user-defined file mapping.
 Otherwise, calls to $getShortNames() will create/augment the mapping for filenames.}
\description{
Make sure to call $readMappingFile(some_file) if you want to support a user-defined file mapping.
 Otherwise, calls to $getShortNames() will create/augment the mapping for filenames.
}
\section{Fields}{

\describe{
\item{\code{raw_file_mapping}}{Data.frame with columns 'from', 'to' and maybe 'best.effort' (if shorting was unsuccessful)}

\item{\code{mapping.creation}}{how the current mapping was obtained (user or auto)}

\item{\code{external.mapping.file}}{Filename of user-defined mapping file; only defined if readMappingFile() was called}
}}

\section{Methods}{

\describe{
\item{\code{getShortNamesStatic(raw.files, max_len, fallbackStartNr = 1)}}{Static method: Shorten a set of Raw file names and return a data frame with the mappings.
 Mapping will have: $from, $to and optionally $best.effort (if shorting was unsuccessful and numbers had to be used)
 \itemize{
   \item{\verb{raw.files}  Vector of Raw files.}
   \item{\verb{max_len} Maximal length of shortening results, before resorting to canonical names (file 1,...).}
   \item{\verb{fallbackStartNr} Starting index for canonical names.}
 }
 \subsection{Return Value}{ data.frame with mapping.}}
}}

\examples{
a = FilenameMapper$new()
a$readMappingFile('filenamemapping.txt') 

}
