% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_quality.R
\name{plr_pvheatmap}
\alias{plr_pvheatmap}
\title{Title Heatmap generation for PV data}
\usage{
plr_pvheatmap(
  df,
  col,
  timestamp_col,
  timestamp_format = "\%Y-\%m-\%d \%H:\%M:\%S",
  upper_threshold = 1,
  lower_threshold = 0,
  font_size = 12
)
}
\arguments{
\item{df}{dataframe containing at least the timestamp column and the variable to be plotted with the heatmap}

\item{col}{the character name of the column to be ploted}

\item{timestamp_col}{the character name of the timestamp column}

\item{timestamp_format}{the POSIXct format of the timestamp if conversion is needed}

\item{upper_threshold}{the fraction of upper data to include, 1 removes no data, 0.9 remove the top 1 percent etc.}

\item{lower_threshold}{the fraction of lower data to remove, 0 removes no data, 0.01 remove the bottom 1 percent etc.}

\item{font_size}{font size of the output plot}
}
\value{
returns a ggplot object heatmap of the specified column
}
\description{
Title Heatmap generation for PV data
}
\examples{
# build heatmap
heat <- plr_pvheatmap(test_df, col = "g_poa", timestamp_col = "timestamp", 
                      upper_threshold = 0.99, lower_threshold = 0)
# display heatmap
plot(heat)

}
