% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staticmap_getEsrimapBrick.R
\name{staticmap_getEsrimapBrick}
\alias{staticmap_getEsrimapBrick}
\title{Create a rasterBrick from an Esri tiled image server}
\usage{
staticmap_getEsrimapBrick(
  centerLon = NULL,
  centerLat = NULL,
  maptype = "world_topo",
  zoom = 12,
  width = 640,
  height = 640,
  bbox = NULL,
  maxTiles = 20,
  crs = sp::CRS("+init=epsg:4326"),
  tileCacheDir = tempdir()
)
}
\arguments{
\item{centerLon}{Map center longitude.}

\item{centerLat}{Map center latitude.}

\item{maptype}{Selects the appropriate Esri tile server. Options include:
\itemize{
  \item "world_topo"
  \item "world_imagery"
  \item "world_terrain"
  \item "de_Lorme"
  \item "world_grey"
  \item "world_streets"
}}

\item{zoom}{map Zoom level.}

\item{width}{Width of image, in pixels.}

\item{height}{Height of image, in pixels.}

\item{bbox}{Bounding box vector (lonLo, latLo, lonHi, latHi). If not null,
\code{centerLon}, \code{centerLat}, and \code{zoom} are ignored.}

\item{maxTiles}{Maximum number of tiles to be returned. The greater the
number, the slower the performance -- arbitrarily set to 20 by default.}

\item{crs}{Object of class CRS. The Coordinate Reference System (CRS) for the
returned map. If the CRS of the downloaded map does not match, it will be
projected to the specified CRS using \code{raster::projectRaster}.}

\item{tileCacheDir}{Optional location for cached tiles.}
}
\value{
A rasterBrick object which can be plotted with
\code{staticmap_plotRasterBrick()} or \code{raster::plotRGB()} and serve as a
base plot.
}
\description{
Uses the input coordinates to fetch and composite a raster from
the tile server. Returns a \code{raster::rasterBrick} object. This
can then passed as the \code{rasterBrick} object to the
\code{staticmap_plotRasterBrick()} function for plotting.

As of July 2019, this list is a handy reference to the freely available tile
servers which can be previewed at the following URL:

\url{https://leaflet-extras.github.io/leaflet-providers/preview/}
}
\note{
The spatial reference of the image when it is downloaded is 3857. If
the crs argument is different, projecting may cause the size and extent of
the image to differ very slightly from the input, on a scale of 1-2 pixels or
10^-3 degrees.

If bbox is specified and the bbox aspect ratio does not match the
width/height aspect ratio the extent is resized to prevent the map image from
appearing stretched, so the map extent may not match the bbox argument
exactly.

If both \code{zoom} and \code{maxTiles} are specified, \code{maxTiles}
takes precedence. To get a specified zoom level, set \code{maxTiles = NULL}.
}
\examples{
\dontrun{
rasterBrick <- staticmap_getEsrimapBrick(-122.3318, 47.668)
staticmap_plotRasterBrick(rasterBrick)
}
}
\seealso{
\code{\link{staticmap_getRasterBrick}}

\code{\link{staticmap_plotRasterBrick}}
}
\keyword{plotting}
