// Generated by rstantools.  Do not edit by hand.

/*
    pandemicLP is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pandemicLP is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pandemicLP.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_pandemicModels_multiWave_negbin_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_pandemicModels_multiWave_negbin");
    reader.add_event(117, 115, "end", "model_pandemicModels_multiWave_negbin");
    return reader;
}
template <typename T1__, typename T2__, typename T3__>
typename boost::math::tools::promote_args<T1__, T2__, T3__>::type
genLog(const int& t,
           const T1__& a,
           const T2__& b,
           const T3__& c,
           const int& logScale, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 8;
        local_scalar_t__ logV(DUMMY_VAR__);
        (void) logV;  // dummy to suppress unused var warning
        stan::math::initialize(logV, DUMMY_VAR__);
        stan::math::fill(logV, DUMMY_VAR__);
        stan::math::assign(logV,(((stan::math::log(a) + stan::math::log(c)) - (c * t)) - (2 * stan::math::log((b + stan::math::exp((-(c) * t)))))));
        current_statement_begin__ = 9;
        if (as_bool(logScale)) {
            current_statement_begin__ = 10;
            return stan::math::promote_scalar<fun_return_scalar_t__>(logV);
        } else {
            current_statement_begin__ = 12;
            return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::exp(logV));
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct genLog_functor__ {
    template <typename T1__, typename T2__, typename T3__>
        typename boost::math::tools::promote_args<T1__, T2__, T3__>::type
    operator()(const int& t,
           const T1__& a,
           const T2__& b,
           const T3__& c,
           const int& logScale, std::ostream* pstream__) const {
        return genLog(t, a, b, c, logScale, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_pandemicModels_multiWave_negbin
  : public stan::model::model_base_crtp<model_pandemicModels_multiWave_negbin> {
private:
        int n;
        std::vector<int> y;
        double pop;
        double p;
        int nCurves;
        std::vector<int> w1;
        std::vector<int> w2;
        std::vector<int> w3;
        double phiTrunc;
        double a_alpha;
        double a_beta;
        double mu_delta;
        double sigma2_delta;
        double c_alpha;
        double c_beta;
        double alpha_alpha;
        double alpha_beta;
        double d_1_alpha;
        double d_1_beta;
        double d_2_alpha;
        double d_2_beta;
        double d_3_alpha;
        double d_3_beta;
        double mu_b_1;
        double sigma2_b_1;
        double phi_alpha;
        double phi_beta;
        double f_alpha;
        double f_beta;
public:
    model_pandemicModels_multiWave_negbin(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_pandemicModels_multiWave_negbin(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_pandemicModels_multiWave_negbin_namespace::model_pandemicModels_multiWave_negbin";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 21;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 1);
            current_statement_begin__ = 22;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(n));
            y = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < y_k_0_max__; ++k_0__) {
                y[k_0__] = vals_i__[pos__++];
            }
            size_t y_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < y_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "y[i_0__]", y[i_0__], 0);
            }
            current_statement_begin__ = 23;
            context__.validate_dims("data initialization", "pop", "double", context__.to_vec());
            pop = double(0);
            vals_r__ = context__.vals_r("pop");
            pos__ = 0;
            pop = vals_r__[pos__++];
            current_statement_begin__ = 24;
            context__.validate_dims("data initialization", "p", "double", context__.to_vec());
            p = double(0);
            vals_r__ = context__.vals_r("p");
            pos__ = 0;
            p = vals_r__[pos__++];
            check_greater_or_equal(function__, "p", p, 0);
            check_less_or_equal(function__, "p", p, 1);
            current_statement_begin__ = 25;
            context__.validate_dims("data initialization", "nCurves", "int", context__.to_vec());
            nCurves = int(0);
            vals_i__ = context__.vals_i("nCurves");
            pos__ = 0;
            nCurves = vals_i__[pos__++];
            check_greater_or_equal(function__, "nCurves", nCurves, 1);
            current_statement_begin__ = 26;
            validate_non_negative_index("w1", "nCurves", nCurves);
            context__.validate_dims("data initialization", "w1", "int", context__.to_vec(nCurves));
            w1 = std::vector<int>(nCurves, int(0));
            vals_i__ = context__.vals_i("w1");
            pos__ = 0;
            size_t w1_k_0_max__ = nCurves;
            for (size_t k_0__ = 0; k_0__ < w1_k_0_max__; ++k_0__) {
                w1[k_0__] = vals_i__[pos__++];
            }
            size_t w1_i_0_max__ = nCurves;
            for (size_t i_0__ = 0; i_0__ < w1_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "w1[i_0__]", w1[i_0__], 0);
                check_less_or_equal(function__, "w1[i_0__]", w1[i_0__], 7);
            }
            current_statement_begin__ = 27;
            validate_non_negative_index("w2", "nCurves", nCurves);
            context__.validate_dims("data initialization", "w2", "int", context__.to_vec(nCurves));
            w2 = std::vector<int>(nCurves, int(0));
            vals_i__ = context__.vals_i("w2");
            pos__ = 0;
            size_t w2_k_0_max__ = nCurves;
            for (size_t k_0__ = 0; k_0__ < w2_k_0_max__; ++k_0__) {
                w2[k_0__] = vals_i__[pos__++];
            }
            size_t w2_i_0_max__ = nCurves;
            for (size_t i_0__ = 0; i_0__ < w2_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "w2[i_0__]", w2[i_0__], 0);
                check_less_or_equal(function__, "w2[i_0__]", w2[i_0__], 7);
            }
            current_statement_begin__ = 28;
            validate_non_negative_index("w3", "nCurves", nCurves);
            context__.validate_dims("data initialization", "w3", "int", context__.to_vec(nCurves));
            w3 = std::vector<int>(nCurves, int(0));
            vals_i__ = context__.vals_i("w3");
            pos__ = 0;
            size_t w3_k_0_max__ = nCurves;
            for (size_t k_0__ = 0; k_0__ < w3_k_0_max__; ++k_0__) {
                w3[k_0__] = vals_i__[pos__++];
            }
            size_t w3_i_0_max__ = nCurves;
            for (size_t i_0__ = 0; i_0__ < w3_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "w3[i_0__]", w3[i_0__], 0);
                check_less_or_equal(function__, "w3[i_0__]", w3[i_0__], 7);
            }
            current_statement_begin__ = 29;
            context__.validate_dims("data initialization", "phiTrunc", "double", context__.to_vec());
            phiTrunc = double(0);
            vals_r__ = context__.vals_r("phiTrunc");
            pos__ = 0;
            phiTrunc = vals_r__[pos__++];
            check_greater_or_equal(function__, "phiTrunc", phiTrunc, 0);
            current_statement_begin__ = 33;
            context__.validate_dims("data initialization", "a_alpha", "double", context__.to_vec());
            a_alpha = double(0);
            vals_r__ = context__.vals_r("a_alpha");
            pos__ = 0;
            a_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "a_alpha", a_alpha, 0);
            current_statement_begin__ = 34;
            context__.validate_dims("data initialization", "a_beta", "double", context__.to_vec());
            a_beta = double(0);
            vals_r__ = context__.vals_r("a_beta");
            pos__ = 0;
            a_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "a_beta", a_beta, 0);
            current_statement_begin__ = 35;
            context__.validate_dims("data initialization", "mu_delta", "double", context__.to_vec());
            mu_delta = double(0);
            vals_r__ = context__.vals_r("mu_delta");
            pos__ = 0;
            mu_delta = vals_r__[pos__++];
            current_statement_begin__ = 36;
            context__.validate_dims("data initialization", "sigma2_delta", "double", context__.to_vec());
            sigma2_delta = double(0);
            vals_r__ = context__.vals_r("sigma2_delta");
            pos__ = 0;
            sigma2_delta = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma2_delta", sigma2_delta, 0);
            current_statement_begin__ = 37;
            context__.validate_dims("data initialization", "c_alpha", "double", context__.to_vec());
            c_alpha = double(0);
            vals_r__ = context__.vals_r("c_alpha");
            pos__ = 0;
            c_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "c_alpha", c_alpha, 0);
            current_statement_begin__ = 38;
            context__.validate_dims("data initialization", "c_beta", "double", context__.to_vec());
            c_beta = double(0);
            vals_r__ = context__.vals_r("c_beta");
            pos__ = 0;
            c_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "c_beta", c_beta, 0);
            current_statement_begin__ = 39;
            context__.validate_dims("data initialization", "alpha_alpha", "double", context__.to_vec());
            alpha_alpha = double(0);
            vals_r__ = context__.vals_r("alpha_alpha");
            pos__ = 0;
            alpha_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "alpha_alpha", alpha_alpha, 0);
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "alpha_beta", "double", context__.to_vec());
            alpha_beta = double(0);
            vals_r__ = context__.vals_r("alpha_beta");
            pos__ = 0;
            alpha_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "alpha_beta", alpha_beta, 0);
            current_statement_begin__ = 41;
            context__.validate_dims("data initialization", "d_1_alpha", "double", context__.to_vec());
            d_1_alpha = double(0);
            vals_r__ = context__.vals_r("d_1_alpha");
            pos__ = 0;
            d_1_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "d_1_alpha", d_1_alpha, 0);
            current_statement_begin__ = 42;
            context__.validate_dims("data initialization", "d_1_beta", "double", context__.to_vec());
            d_1_beta = double(0);
            vals_r__ = context__.vals_r("d_1_beta");
            pos__ = 0;
            d_1_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "d_1_beta", d_1_beta, 0);
            current_statement_begin__ = 43;
            context__.validate_dims("data initialization", "d_2_alpha", "double", context__.to_vec());
            d_2_alpha = double(0);
            vals_r__ = context__.vals_r("d_2_alpha");
            pos__ = 0;
            d_2_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "d_2_alpha", d_2_alpha, 0);
            current_statement_begin__ = 44;
            context__.validate_dims("data initialization", "d_2_beta", "double", context__.to_vec());
            d_2_beta = double(0);
            vals_r__ = context__.vals_r("d_2_beta");
            pos__ = 0;
            d_2_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "d_2_beta", d_2_beta, 0);
            current_statement_begin__ = 45;
            context__.validate_dims("data initialization", "d_3_alpha", "double", context__.to_vec());
            d_3_alpha = double(0);
            vals_r__ = context__.vals_r("d_3_alpha");
            pos__ = 0;
            d_3_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "d_3_alpha", d_3_alpha, 0);
            current_statement_begin__ = 46;
            context__.validate_dims("data initialization", "d_3_beta", "double", context__.to_vec());
            d_3_beta = double(0);
            vals_r__ = context__.vals_r("d_3_beta");
            pos__ = 0;
            d_3_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "d_3_beta", d_3_beta, 0);
            current_statement_begin__ = 47;
            context__.validate_dims("data initialization", "mu_b_1", "double", context__.to_vec());
            mu_b_1 = double(0);
            vals_r__ = context__.vals_r("mu_b_1");
            pos__ = 0;
            mu_b_1 = vals_r__[pos__++];
            current_statement_begin__ = 48;
            context__.validate_dims("data initialization", "sigma2_b_1", "double", context__.to_vec());
            sigma2_b_1 = double(0);
            vals_r__ = context__.vals_r("sigma2_b_1");
            pos__ = 0;
            sigma2_b_1 = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma2_b_1", sigma2_b_1, 0);
            current_statement_begin__ = 49;
            context__.validate_dims("data initialization", "phi_alpha", "double", context__.to_vec());
            phi_alpha = double(0);
            vals_r__ = context__.vals_r("phi_alpha");
            pos__ = 0;
            phi_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "phi_alpha", phi_alpha, 0);
            current_statement_begin__ = 50;
            context__.validate_dims("data initialization", "phi_beta", "double", context__.to_vec());
            phi_beta = double(0);
            vals_r__ = context__.vals_r("phi_beta");
            pos__ = 0;
            phi_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "phi_beta", phi_beta, 0);
            current_statement_begin__ = 51;
            context__.validate_dims("data initialization", "f_alpha", "double", context__.to_vec());
            f_alpha = double(0);
            vals_r__ = context__.vals_r("f_alpha");
            pos__ = 0;
            f_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "f_alpha", f_alpha, 0);
            current_statement_begin__ = 52;
            context__.validate_dims("data initialization", "f_beta", "double", context__.to_vec());
            f_beta = double(0);
            vals_r__ = context__.vals_r("f_beta");
            pos__ = 0;
            f_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "f_beta", f_beta, 0);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 59;
            validate_non_negative_index("b1", "nCurves", nCurves);
            num_params_r__ += nCurves;
            current_statement_begin__ = 60;
            validate_non_negative_index("a", "nCurves", nCurves);
            num_params_r__ += (1 * nCurves);
            current_statement_begin__ = 62;
            validate_non_negative_index("c", "nCurves", nCurves);
            num_params_r__ += (1 * nCurves);
            current_statement_begin__ = 65;
            validate_non_negative_index("d_1", "nCurves", nCurves);
            num_params_r__ += (1 * nCurves);
            current_statement_begin__ = 66;
            validate_non_negative_index("d_2", "nCurves", nCurves);
            num_params_r__ += (1 * nCurves);
            current_statement_begin__ = 67;
            validate_non_negative_index("d_3", "nCurves", nCurves);
            num_params_r__ += (1 * nCurves);
            current_statement_begin__ = 70;
            validate_non_negative_index("alpha", "nCurves", nCurves);
            num_params_r__ += nCurves;
            current_statement_begin__ = 71;
            validate_non_negative_index("delta", "nCurves", nCurves);
            num_params_r__ += nCurves;
            current_statement_begin__ = 74;
            num_params_r__ += 1;
            current_statement_begin__ = 75;
            validate_non_negative_index("lambda", "n", n);
            num_params_r__ += n;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_pandemicModels_multiWave_negbin() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 59;
        if (!(context__.contains_r("b1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable b1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("b1");
        pos__ = 0U;
        validate_non_negative_index("b1", "nCurves", nCurves);
        context__.validate_dims("parameter initialization", "b1", "vector_d", context__.to_vec(nCurves));
        Eigen::Matrix<double, Eigen::Dynamic, 1> b1(nCurves);
        size_t b1_j_1_max__ = nCurves;
        for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
            b1(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(b1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable b1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 60;
        if (!(context__.contains_r("a")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable a missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("a");
        pos__ = 0U;
        validate_non_negative_index("a", "nCurves", nCurves);
        context__.validate_dims("parameter initialization", "a", "double", context__.to_vec(nCurves));
        std::vector<double> a(nCurves, double(0));
        size_t a_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < a_k_0_max__; ++k_0__) {
            a[k_0__] = vals_r__[pos__++];
        }
        size_t a_i_0_max__ = nCurves;
        for (size_t i_0__ = 0; i_0__ < a_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lub_unconstrain(0, min(multiply((p * pop), stan::math::exp(b1))), a[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable a: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 62;
        if (!(context__.contains_r("c")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable c missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("c");
        pos__ = 0U;
        validate_non_negative_index("c", "nCurves", nCurves);
        context__.validate_dims("parameter initialization", "c", "double", context__.to_vec(nCurves));
        std::vector<double> c(nCurves, double(0));
        size_t c_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < c_k_0_max__; ++k_0__) {
            c[k_0__] = vals_r__[pos__++];
        }
        size_t c_i_0_max__ = nCurves;
        for (size_t i_0__ = 0; i_0__ < c_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, c[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable c: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 65;
        if (!(context__.contains_r("d_1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable d_1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("d_1");
        pos__ = 0U;
        validate_non_negative_index("d_1", "nCurves", nCurves);
        context__.validate_dims("parameter initialization", "d_1", "double", context__.to_vec(nCurves));
        std::vector<double> d_1(nCurves, double(0));
        size_t d_1_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < d_1_k_0_max__; ++k_0__) {
            d_1[k_0__] = vals_r__[pos__++];
        }
        size_t d_1_i_0_max__ = nCurves;
        for (size_t i_0__ = 0; i_0__ < d_1_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, d_1[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable d_1: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 66;
        if (!(context__.contains_r("d_2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable d_2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("d_2");
        pos__ = 0U;
        validate_non_negative_index("d_2", "nCurves", nCurves);
        context__.validate_dims("parameter initialization", "d_2", "double", context__.to_vec(nCurves));
        std::vector<double> d_2(nCurves, double(0));
        size_t d_2_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < d_2_k_0_max__; ++k_0__) {
            d_2[k_0__] = vals_r__[pos__++];
        }
        size_t d_2_i_0_max__ = nCurves;
        for (size_t i_0__ = 0; i_0__ < d_2_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, d_2[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable d_2: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 67;
        if (!(context__.contains_r("d_3")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable d_3 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("d_3");
        pos__ = 0U;
        validate_non_negative_index("d_3", "nCurves", nCurves);
        context__.validate_dims("parameter initialization", "d_3", "double", context__.to_vec(nCurves));
        std::vector<double> d_3(nCurves, double(0));
        size_t d_3_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < d_3_k_0_max__; ++k_0__) {
            d_3[k_0__] = vals_r__[pos__++];
        }
        size_t d_3_i_0_max__ = nCurves;
        for (size_t i_0__ = 0; i_0__ < d_3_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, d_3[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable d_3: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 70;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        validate_non_negative_index("alpha", "nCurves", nCurves);
        context__.validate_dims("parameter initialization", "alpha", "vector_d", context__.to_vec(nCurves));
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha(nCurves);
        size_t alpha_j_1_max__ = nCurves;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            alpha(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, alpha);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 71;
        if (!(context__.contains_r("delta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        validate_non_negative_index("delta", "nCurves", nCurves);
        context__.validate_dims("parameter initialization", "delta", "vector_d", context__.to_vec(nCurves));
        Eigen::Matrix<double, Eigen::Dynamic, 1> delta(nCurves);
        size_t delta_j_1_max__ = nCurves;
        for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
            delta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(delta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 74;
        if (!(context__.contains_r("phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "phi", "double", context__.to_vec());
        double phi(0);
        phi = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(phiTrunc, phi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 75;
        if (!(context__.contains_r("lambda")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda");
        pos__ = 0U;
        validate_non_negative_index("lambda", "n", n);
        context__.validate_dims("parameter initialization", "lambda", "vector_d", context__.to_vec(n));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda(n);
        size_t lambda_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            lambda(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, lambda);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 59;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b1;
            (void) b1;  // dummy to suppress unused var warning
            if (jacobian__)
                b1 = in__.vector_constrain(nCurves, lp__);
            else
                b1 = in__.vector_constrain(nCurves);
            current_statement_begin__ = 60;
            std::vector<local_scalar_t__> a;
            size_t a_d_0_max__ = nCurves;
            a.reserve(a_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < a_d_0_max__; ++d_0__) {
                if (jacobian__)
                    a.push_back(in__.scalar_lub_constrain(0, min(multiply((p * pop), stan::math::exp(b1))), lp__));
                else
                    a.push_back(in__.scalar_lub_constrain(0, min(multiply((p * pop), stan::math::exp(b1)))));
            }
            current_statement_begin__ = 62;
            std::vector<local_scalar_t__> c;
            size_t c_d_0_max__ = nCurves;
            c.reserve(c_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < c_d_0_max__; ++d_0__) {
                if (jacobian__)
                    c.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    c.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 65;
            std::vector<local_scalar_t__> d_1;
            size_t d_1_d_0_max__ = nCurves;
            d_1.reserve(d_1_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < d_1_d_0_max__; ++d_0__) {
                if (jacobian__)
                    d_1.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    d_1.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 66;
            std::vector<local_scalar_t__> d_2;
            size_t d_2_d_0_max__ = nCurves;
            d_2.reserve(d_2_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < d_2_d_0_max__; ++d_0__) {
                if (jacobian__)
                    d_2.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    d_2.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 67;
            std::vector<local_scalar_t__> d_3;
            size_t d_3_d_0_max__ = nCurves;
            d_3.reserve(d_3_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < d_3_d_0_max__; ++d_0__) {
                if (jacobian__)
                    d_3.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    d_3.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 70;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.vector_lb_constrain(0, nCurves, lp__);
            else
                alpha = in__.vector_lb_constrain(0, nCurves);
            current_statement_begin__ = 71;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delta;
            (void) delta;  // dummy to suppress unused var warning
            if (jacobian__)
                delta = in__.vector_constrain(nCurves, lp__);
            else
                delta = in__.vector_constrain(nCurves);
            current_statement_begin__ = 74;
            local_scalar_t__ phi;
            (void) phi;  // dummy to suppress unused var warning
            if (jacobian__)
                phi = in__.scalar_lb_constrain(phiTrunc, lp__);
            else
                phi = in__.scalar_lb_constrain(phiTrunc);
            current_statement_begin__ = 75;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda;
            (void) lambda;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda = in__.vector_lb_constrain(0, n, lp__);
            else
                lambda = in__.vector_lb_constrain(0, n);
            // transformed parameters
            current_statement_begin__ = 81;
            validate_non_negative_index("b", "nCurves", nCurves);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b(nCurves);
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            stan::math::assign(b,stan::math::exp(b1));
            current_statement_begin__ = 82;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 84;
            for (int t = 1; t <= n; ++t) {
                current_statement_begin__ = 85;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable mu");
                current_statement_begin__ = 86;
                for (int curve = 1; curve <= nCurves; ++curve) {
                    current_statement_begin__ = 87;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), "mu") + stan::math::exp(((((normal_cdf_log((get_base1(alpha, curve, "alpha", 1) * (t - get_base1(delta, curve, "delta", 1))), 0, 1) + genLog(t, get_base1(a, curve, "a", 1), get_base1(b, curve, "b", 1), get_base1(c, curve, "c", 1), 1, pstream__)) + ((logical_eq(modulus((t - get_base1(w1, curve, "w1", 1)), 7), 0) * logical_gt(get_base1(w1, curve, "w1", 1), 0)) * stan::math::log(get_base1(d_1, curve, "d_1", 1)))) + ((logical_eq(modulus((t - get_base1(w2, curve, "w2", 1)), 7), 0) * logical_gt(get_base1(w2, curve, "w2", 1), 0)) * stan::math::log(get_base1(d_2, curve, "d_2", 1)))) + ((logical_eq(modulus((t - get_base1(w3, curve, "w3", 1)), 7), 0) * logical_gt(get_base1(w3, curve, "w3", 1), 0)) * stan::math::log(get_base1(d_3, curve, "d_3", 1)))))), 
                                "assigning variable mu");
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 81;
            size_t b_j_1_max__ = nCurves;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(b(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "b", b, 0);
            current_statement_begin__ = 82;
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "mu", mu, 0);
            check_less_or_equal(function__, "mu", mu, pop);
            // model body
            current_statement_begin__ = 102;
            lp_accum__.add(poisson_log<propto__>(y, lambda));
            current_statement_begin__ = 103;
            lp_accum__.add(gamma_log<propto__>(lambda, multiply(phi, mu), phi));
            current_statement_begin__ = 106;
            lp_accum__.add(gamma_log<propto__>(a, a_alpha, a_beta));
            current_statement_begin__ = 107;
            lp_accum__.add(normal_log<propto__>(delta, mu_delta, sigma2_delta));
            current_statement_begin__ = 109;
            lp_accum__.add(gamma_log<propto__>(alpha, alpha_alpha, alpha_beta));
            current_statement_begin__ = 110;
            lp_accum__.add(gamma_log<propto__>(d_1, d_1_alpha, d_1_beta));
            current_statement_begin__ = 111;
            lp_accum__.add(gamma_log<propto__>(d_2, d_2_alpha, d_2_beta));
            current_statement_begin__ = 112;
            lp_accum__.add(gamma_log<propto__>(d_3, d_3_alpha, d_3_beta));
            current_statement_begin__ = 113;
            lp_accum__.add(gamma_log<propto__>(phi, phi_alpha, phi_beta));
            current_statement_begin__ = 114;
            lp_accum__.add(normal_log<propto__>(b1, mu_b_1, sigma2_b_1));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("b1");
        names__.push_back("a");
        names__.push_back("c");
        names__.push_back("d_1");
        names__.push_back("d_2");
        names__.push_back("d_3");
        names__.push_back("alpha");
        names__.push_back("delta");
        names__.push_back("phi");
        names__.push_back("lambda");
        names__.push_back("b");
        names__.push_back("mu");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nCurves);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nCurves);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nCurves);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nCurves);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nCurves);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nCurves);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nCurves);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nCurves);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nCurves);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_pandemicModels_multiWave_negbin_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> b1 = in__.vector_constrain(nCurves);
        size_t b1_j_1_max__ = nCurves;
        for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
            vars__.push_back(b1(j_1__));
        }
        std::vector<double> a;
        size_t a_d_0_max__ = nCurves;
        a.reserve(a_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < a_d_0_max__; ++d_0__) {
            a.push_back(in__.scalar_lub_constrain(0, min(multiply((p * pop), stan::math::exp(b1)))));
        }
        size_t a_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < a_k_0_max__; ++k_0__) {
            vars__.push_back(a[k_0__]);
        }
        std::vector<double> c;
        size_t c_d_0_max__ = nCurves;
        c.reserve(c_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < c_d_0_max__; ++d_0__) {
            c.push_back(in__.scalar_lb_constrain(0));
        }
        size_t c_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < c_k_0_max__; ++k_0__) {
            vars__.push_back(c[k_0__]);
        }
        std::vector<double> d_1;
        size_t d_1_d_0_max__ = nCurves;
        d_1.reserve(d_1_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < d_1_d_0_max__; ++d_0__) {
            d_1.push_back(in__.scalar_lb_constrain(0));
        }
        size_t d_1_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < d_1_k_0_max__; ++k_0__) {
            vars__.push_back(d_1[k_0__]);
        }
        std::vector<double> d_2;
        size_t d_2_d_0_max__ = nCurves;
        d_2.reserve(d_2_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < d_2_d_0_max__; ++d_0__) {
            d_2.push_back(in__.scalar_lb_constrain(0));
        }
        size_t d_2_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < d_2_k_0_max__; ++k_0__) {
            vars__.push_back(d_2[k_0__]);
        }
        std::vector<double> d_3;
        size_t d_3_d_0_max__ = nCurves;
        d_3.reserve(d_3_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < d_3_d_0_max__; ++d_0__) {
            d_3.push_back(in__.scalar_lb_constrain(0));
        }
        size_t d_3_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < d_3_k_0_max__; ++k_0__) {
            vars__.push_back(d_3[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha = in__.vector_lb_constrain(0, nCurves);
        size_t alpha_j_1_max__ = nCurves;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            vars__.push_back(alpha(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> delta = in__.vector_constrain(nCurves);
        size_t delta_j_1_max__ = nCurves;
        for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
            vars__.push_back(delta(j_1__));
        }
        double phi = in__.scalar_lb_constrain(phiTrunc);
        vars__.push_back(phi);
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda = in__.vector_lb_constrain(0, n);
        size_t lambda_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            vars__.push_back(lambda(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 81;
            validate_non_negative_index("b", "nCurves", nCurves);
            Eigen::Matrix<double, Eigen::Dynamic, 1> b(nCurves);
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            stan::math::assign(b,stan::math::exp(b1));
            current_statement_begin__ = 82;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 84;
            for (int t = 1; t <= n; ++t) {
                current_statement_begin__ = 85;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable mu");
                current_statement_begin__ = 86;
                for (int curve = 1; curve <= nCurves; ++curve) {
                    current_statement_begin__ = 87;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), "mu") + stan::math::exp(((((normal_cdf_log((get_base1(alpha, curve, "alpha", 1) * (t - get_base1(delta, curve, "delta", 1))), 0, 1) + genLog(t, get_base1(a, curve, "a", 1), get_base1(b, curve, "b", 1), get_base1(c, curve, "c", 1), 1, pstream__)) + ((logical_eq(modulus((t - get_base1(w1, curve, "w1", 1)), 7), 0) * logical_gt(get_base1(w1, curve, "w1", 1), 0)) * stan::math::log(get_base1(d_1, curve, "d_1", 1)))) + ((logical_eq(modulus((t - get_base1(w2, curve, "w2", 1)), 7), 0) * logical_gt(get_base1(w2, curve, "w2", 1), 0)) * stan::math::log(get_base1(d_2, curve, "d_2", 1)))) + ((logical_eq(modulus((t - get_base1(w3, curve, "w3", 1)), 7), 0) * logical_gt(get_base1(w3, curve, "w3", 1), 0)) * stan::math::log(get_base1(d_3, curve, "d_3", 1)))))), 
                                "assigning variable mu");
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 81;
            check_greater_or_equal(function__, "b", b, 0);
            current_statement_begin__ = 82;
            check_greater_or_equal(function__, "mu", mu, 0);
            check_less_or_equal(function__, "mu", mu, pop);
            // write transformed parameters
            if (include_tparams__) {
                size_t b_j_1_max__ = nCurves;
                for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                    vars__.push_back(b(j_1__));
                }
                size_t mu_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    vars__.push_back(mu(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_pandemicModels_multiWave_negbin";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t b1_j_1_max__ = nCurves;
        for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t a_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < a_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t c_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < c_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "c" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t d_1_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < d_1_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "d_1" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t d_2_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < d_2_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "d_2" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t d_3_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < d_3_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "d_3" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_j_1_max__ = nCurves;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delta_j_1_max__ = nCurves;
        for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());
        size_t lambda_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t b_j_1_max__ = nCurves;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t b1_j_1_max__ = nCurves;
        for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t a_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < a_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t c_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < c_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "c" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t d_1_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < d_1_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "d_1" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t d_2_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < d_2_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "d_2" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t d_3_k_0_max__ = nCurves;
        for (size_t k_0__ = 0; k_0__ < d_3_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "d_3" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_j_1_max__ = nCurves;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delta_j_1_max__ = nCurves;
        for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());
        size_t lambda_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t b_j_1_max__ = nCurves;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_pandemicModels_multiWave_negbin_namespace::model_pandemicModels_multiWave_negbin stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
