% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance_scatter.R
\name{balance_scatter}
\alias{balance_scatter}
\title{balance_scatter}
\usage{
balance_scatter(
  matched_set_list,
  xlim = c(0, 0.8),
  ylim = c(0, 0.8),
  main = "Standardized Mean Difference of Covariates",
  pchs = c(2, 3),
  covariates,
  data,
  x.axis.label = "Before refinement",
  y.axis.label = "After refinement",
  ...
)
}
\arguments{
\item{matched_set_list}{a list of one or more \code{matched.set} objects}

\item{xlim}{xlim of the scatter plot. This is the same as the \code{xlim} argument in \code{plot()}}

\item{ylim}{ylim of the scatter plot. This is the same as the \code{ylim} argument in \code{plot()}}

\item{main}{title of the scatter plot. This is the same as the \code{main} argument in \code{plot()}}

\item{pchs}{one or more pch indicators for the symbols on the scatter plot. You should specify a pch symbol for each matched.set you specify in matched_set_list. See \code{plot()} for more information}

\item{covariates}{variables for which balance is displayed}

\item{data}{the same time series cross sectional data set used to create the matched sets.}

\item{x.axis.label}{x axis label}

\item{y.axis.label}{y axis label}

\item{...}{optional arguments to be passed to \code{plot()}}
}
\description{
Visualizing the standardized mean differences for covariates via a scatter plot.
}
\details{
\code{balance_scatter} visualizes the standardized mean differences for each covariate.
Although users can use the scatter plot in a variety of ways, it is recommended that
the x-axis refers to balance for covariates before refinement, and y-axis
refers to balance after refinement. Users can utilize parameters powered by \code{plot()}
in base R to further customize the figure.
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
# create subset of data for simplicity
# get a matched set without refinement
sets0 <- PanelMatch(lag = 4, time.id = "year", unit.id = "wbcode2",
                    treatment = "dem", refinement.method = "none",
                    data = dem.sub, match.missing = FALSE,
                    size.match = 5, qoi = "att",
                    outcome.var = "y",
                    lead = 0:4, forbid.treatment.reversal = FALSE)

# get a matched set with refinement using propensity score matching, setting the
# size of matched set to 5
sets1 <- PanelMatch(lag = 4, time.id = "year", unit.id = "wbcode2",
                    treatment = "dem", refinement.method = "ps.match",
                    data = dem.sub, match.missing = FALSE,
                    covs.formula = ~ tradewb,
                    size.match = 5, qoi = "att",
                    outcome.var = "y",
                    lead = 0:4, forbid.treatment.reversal = FALSE)

# get another matched set with refinement using propensity score weighting
sets2 <- PanelMatch(lag = 4, time.id = "year", unit.id = "wbcode2",
                    treatment = "dem", refinement.method = "ps.weight",
                    data = dem.sub, match.missing = FALSE,
                    covs.formula = ~ tradewb,
                    size.match = 10, qoi = "att",
                    outcome.var = "y",
                    lead = 0:4, forbid.treatment.reversal = FALSE)


# use the function to produce the scatter plot
balance_scatter(matched_set_list = list(sets0$att, sets1$att, sets2$att),
              data = dem.sub,
              covariates = c("y", "tradewb"))
# add legend
legend(x = 0, y = 0.8,
legend = c("mahalanobis",
           "PS weighting"),
y.intersp = 0.65,
x.intersp = 0.3,
xjust = 0,
pch = c(1, 3), pt.cex = 1,
bty = "n", ncol = 1, cex = 1, bg = "white")



}
\author{
In Song Kim <insong@mit.edu>, Erik Wang
<haixiao@Princeton.edu>, Adam Rauh <amrauh@umich.edu>, and Kosuke Imai <imai@harvard.edu>
}
