% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EvaluatePlp.R
\name{evaluatePlp}
\alias{evaluatePlp}
\title{evaluatePlp}
\usage{
evaluatePlp(prediction, typeColumn = "evaluationType")
}
\arguments{
\item{prediction}{The patient level prediction model's prediction}

\item{typeColumn}{The column name in the prediction object that is used to
stratify the evaluation}
}
\value{
An object of class plpEvaluation containing the following components
\itemize{
\item evaluationStatistics: A data frame containing the evaluation statistics'
\item thresholdSummary: A data frame containing the threshold summary'
\item demographicSummary: A data frame containing the demographic summary'
\item calibrationSummary: A data frame containing the calibration summary'
\item predictionDistribution: A data frame containing the prediction distribution'
}
}
\description{
Evaluates the performance of the patient level prediction model
}
\details{
The function calculates various metrics to measure the performance of the model
}
\examples{
\donttest{ \dontshow{ # takes too long to run }
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n= 1500)
population <- createStudyPopulation(plpData, outcomeId = 3, 
                                    populationSettings = createStudyPopulationSettings())
data <- splitData(plpData, population, splitSettings=createDefaultSplitSetting(splitSeed=42))
data$Train$covariateData <- preprocessData(data$Train$covariateData, 
                                           createPreprocessSettings())
path <- file.path(tempdir(), "plp")
model <- fitPlp(data$Train, modelSettings=setLassoLogisticRegression(seed=42),
                analysisId=1, analysisPath = path)
evaluatePlp(model$prediction) # Train and CV metrics
}
}
