% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_array-network.R
\name{gene_expr_simulation,network-method}
\alias{gene_expr_simulation,network-method}
\alias{gene_expr_simulation}
\alias{gene_expr_simulation-methods}
\title{Simulates microarray data based on a given network.}
\usage{
\S4method{gene_expr_simulation}{network}(
  network,
  time_label = 1:4,
  subject = 5,
  peak_level = 100,
  act_time_group = 1:4
)
}
\arguments{
\item{network}{A network object.}

\item{time_label}{a vector containing the time labels.}

\item{subject}{the number of subjects}

\item{peak_level}{the mean level of peaks.}

\item{act_time_group}{[NULL] vector ; at which time the groups (defined by sort(unique(group))) are activated ?}
}
\value{
A micro_array object.
}
\description{
Simulates microarray data based on a given network.
}
\examples{

data(Net)
set.seed(1)

#We simulate gene expressions according to the network Net
Msim<-Patterns::gene_expr_simulation(
	network=Net,
	time_label=rep(1:4,each=25),
	subject=5,
	peak_level=200)
head(Msim)

}
\author{
Bertrand Frederic, Myriam Maumy-Bertrand.
}
