% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peptide_cluster_quantification.R
\name{calculate_Area}
\alias{calculate_Area}
\title{Calculate Area/Intensity for one row of the input sequence dataframe}
\usage{
calculate_Area(
  row,
  matching_result,
  matching_columns,
  distinct_columns = NULL,
  area_column,
  with_PTM = FALSE,
  reps = FALSE
)
}
\arguments{
\item{row}{A row of dataframe containing the sequence for the 'Character' column in region_data.}

\item{matching_result}{The dataframe that contains the matched results and PTM information.}

\item{matching_columns}{Vector of column names that should match between the 'row' and 'matching_result' dataframes.}

\item{distinct_columns}{Vector of column names that should be used to calculate Area separately for each unique combination of these columns.}

\item{area_column}{The name of the column in 'matching_result' that contains the area/intensity information.}

\item{with_PTM}{A boolean parameter indicating whether PTM should be considered. If \code{with_PTM = TRUE},
the function will also add 'PTM' and 'PTM_type' to the result 'region_data' dataframe. Default is \code{FALSE}.}

\item{reps}{A boolean parameter indicating whether the area/intensity should be divided by the number of replicates. Default is \code{FALSE}.}
}
\value{
This function returns the modified \code{region_data} dataframe that includes the "Area" column, and optionally "PTM" and "PTM_type" columns.
If the 'filter_conditions' do not match, an empty dataframe will be returned early.
An AttributeError is raised if 'PTM_position' and 'PTM_type' columns do not exist in the 'result' dataframe when 'with_PTM' is \code{TRUE}.
}
\description{
Calculate Area/Intensity for one row of the input sequence dataframe
}
\examples{
row <- data.frame(
 Region_Sequence = c("XYZAAA"),
 Condition_1 = c("Drug1"),
 Condition_2 = c("Donor1"),
 Region_1 = c("VH"),
 Region_2 = c("Arm_1")
)
matching_result <- data.frame(
  Sequence = c("AAA", "DDD", "DDD"),
  Condition_1 = c("Drug1", "Drug2", "Drug2"),
  Condition_2 = c("Donor1", "Donor2", "Donor2"),
  Region_1 = c("VH", "VL", "VL"),
  Region_2 = c("Arm_1", "Arm_2", "Arm_2"),
  Start_Position = c(4, 4, 4),
  End_Position = c(6, 6, 6),
  PTM_position = c(NA, 2, 0),
  PTM_type = c(NA,"O","C"),
  Area = c(100, 200, 200),
  reps = c(1, 2, 2)
)
matching_columns <- c("Condition_1", "Region_2")
area_column <- "Area"
data_with_area <- calculate_Area(
  row,
  matching_result,
  matching_columns,
  distinct_columns = c("Condition_2", "Region_1"),
  area_column,
  with_PTM = TRUE,
  reps = TRUE
)

}
