% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_modification.R
\name{obtain_mod_PEAKS}
\alias{obtain_mod_PEAKS}
\title{Obtain modification information from Peptide data generated by PEAKS}
\usage{
obtain_mod_PEAKS(
  data,
  column,
  PTM_table = NULL,
  PTM_annotation = FALSE,
  PTM_mass_column
)
}
\arguments{
\item{data}{A dataframe with a column containing modified peptide sequences.}

\item{column}{The name of the column containing the modified peptide sequences.}

\item{PTM_table}{A dataframe with columns 'PTM_mass' and 'PTM_type' containing PTM annotation information.}

\item{PTM_annotation}{A logical value indicating whether to include PTM annotation information in the result.}

\item{PTM_mass_column}{The name of the column containing the PTM mass information}
}
\value{
A data.table with 'PTM_position', 'PTM_type', 'PTM_mass', 'reps', and other columns.
}
\description{
This function takes PEAKS output containing a column with modified peptide
sequences including PTM information and converts it into a new dataframe with the
desired format of peptide sequences and associated PTM information.
}
\examples{
library(data.table)
data <- data.table(
  Peptide = c(
    "AAN(+42)Q(-0.98)RGSLYQCDYSTGSC(+57.02)EPIR",
    "K.AAQQTGKLVHANFGT.K",
    "K.(-0.98)AATVTGKLVHANFGT.K"
  ),
  Sequence = c(
    "AANQRGSLYQCDYSTGSCEPIR",
    "AAQQTGKLVHANFGT",
    "AATVTGKLVHANFGT"
  ),
  Condition = c("A", "B", "B")
)
PTM_table <- data.table(PTM_mass = c(42, -0.98, 57.02),
                        PTM_type = c("Acet", "Amid", "Cam"))
column <- "Peptide"
PTM_mass_column <- "PTM_mass"
converted_data <- obtain_mod_PEAKS(data, column, PTM_table, PTM_annotation = TRUE, PTM_mass_column)

}
