% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massShift.R
\name{massShift}
\alias{massShift}
\title{Calculate the mass difference of modified peptides.}
\source{
For the predefined heavy isotope labels, compare:
\itemize{
 \item{silac_13c}{
   \href{http://www.unimod.org/modifications_view.php?editid1=188}{Unimod 188}
 }
 \item{silac_13c15n}{
   \href{http://www.unimod.org/modifications_view.php?editid1=259}{Unimod 259} and
   \href{http://www.unimod.org/modifications_view.php?editid1=267}{Unimod 267}
 }
 \item{15n}{
   \href{http://www.unimod.org/modifications_view.php?editid1=994}{Unimod 994}, 
   \href{http://www.unimod.org/modifications_view.php?editid1=995}{Unimod 995}, 
   \href{http://www.unimod.org/modifications_view.php?editid1=996}{Unimod 996} and 
   \href{http://www.unimod.org/modifications_view.php?editid1=897}{Unimod 897}
 }
}
}
\usage{
massShift(seq, label = "none", aaShift = NULL, monoisotopic = TRUE)
}
\arguments{
\item{seq}{An amino-acids sequence, in one letter code.}

\item{label}{Set a predefined heavy isotope label. Accepts "none", "silac_13c", "silac_13c15n" and "15n". Overwrites input in \code{aaShift}.}

\item{aaShift}{Define the mass difference in Dalton of given amino acids as a named vector. 
Use the amino acid one letter code as names and the mass shift in Dalton as values. 
N-terminal and C-terminal modifications can be defined by using "Nterm =" and "Cterm =", respectively.}

\item{monoisotopic}{A logical value \code{'TRUE'} or \code{'FALSE'} indicating if monoisotopic weights of amino-acids should be used}
}
\description{
This function calculates the mass difference of peptides introduced by chemical modifications or heavy isotope labelling.
}
\examples{
massShift("EGVNDNECEGFFSAR", label = "silac_13c")
massShift("EGVNDNECEGFFSAR", aaShift = c(K = 6.020129, R = 6.020129))

}
