% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply.rolling.R
\name{apply.rolling}
\alias{apply.rolling}
\title{calculate a function over a rolling window}
\usage{
apply.rolling(R, width, trim = TRUE, gap = 12, by = 1,
  FUN = "mean", ...)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of
asset returns}

\item{width}{number of periods to apply rolling function window over}

\item{trim}{TRUE/FALSE, whether to keep alignment caused by NA's}

\item{gap}{numeric number of periods from start of series to use to train
risk calculation}

\item{by}{calculate FUN for trailing width points at every by-th time point.}

\item{FUN}{any function that can be evaluated using a single set of returns
(e.g., rolling beta won't work, but \code{\link{Return.annualized}} will)}

\item{\dots}{any other passthru parameters}
}
\value{
A timeseries in a zoo object of the calculation results
}
\description{
Creates a results timeseries of a function applied over a rolling window.
}
\details{
Wrapper function for \code{\link[zoo]{rollapply}} to hide some of the
complexity of managing single-column zoo objects.
}
\examples{

data(managers)
apply.rolling(managers[,1,drop=FALSE], FUN="mean", width=36)

}
\seealso{
\code{\link{apply}} \cr \code{\link[zoo]{rollapply}}
}
\author{
Peter Carl
}
