% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_load_indicator.R
\name{compute_pesticide_load_indicator}
\alias{compute_pesticide_load_indicator}
\title{Compute Pesticide Load Indicator with user supplied information on pesticide properties}
\usage{
compute_pesticide_load_indicator(substances, products)
}
\arguments{
\item{substances}{Dataframe describing active ingredients of the applied pesticide products, including their ecotoxicity, fate and human health properties.}

\item{products}{Dataframe with raw pesticide application data.}
}
\value{
Dataframe with pesticide indicators for each pesticide application
indicated in the products dataframe.
Computes Pesticide Load Indicator (L) and its subindicators:
The Human Health Load (HL), Ecotoxicity Load (TL) and Fate Load (FL).
If standard dosages are provided the Standard Treatment Index (STI) and
the Pesticide Load Index (LI=STI*L) are also computed.
}
\description{
Compute Pesticide Load Indicator with user supplied information on pesticide properties
}
\examples{
\dontrun{
# load the dataframe containing the pesticide use data.
products_user <- products.load()
# load the (user-supplied) dataframe with detailed information on used pesticides.
substances_user <- substances.load()

# Compute the Pesticide Load Indicator and its sub-indicators using the user supplied data.
indicators_user <- compute_pesticide_load_indicator(substances = substances_user,
products= products_user)
}
}
