% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetDesire}
\alias{GetDesire}
\title{Returns the desireability value of a dose.}
\usage{
GetDesire(PE, PT, Contour)
}
\arguments{
\item{PE}{True or estimated probability of efficacy.}

\item{PT}{True of estimated probability of toxicity.}

\item{Contour}{Vector containing 4 entries used to make the desireability function. Contour(1) contains a desired toxicity probability given efficacy, Countour(2) contains a desired efficacy probability given toxicity, and (Contour(3),Contour(4)) is an equally desireable pair of efficacy and toxicity probabilities that are non zero or one.}
}
\value{
Computes the real-valued desireability for an estimated (PE, PT) pair and elicited co
}
\description{
Takes estimated posterior mean efficacy and toxicity values and returns the posterior mean desireability score for a given tradeoff contour.
}
\examples{
PE=.6
PT=.2
##Contour values
Contour=c(.35,.7,.8,.6)
GetDesire(PE,PT,Contour)
}
