% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.PhyloEM}
\alias{plot.PhyloEM}
\title{Plot for class \code{PhyloEM}}
\usage{
\method{plot}{PhyloEM}(x, traits = 1:(x$p), params = NULL,
  method.selection = NULL, automatic_colors = TRUE,
  color_characters = "black", color_edges = "black",
  plot_ancestral_states = FALSE, imposed_scale, ancestral_cex = 2,
  ancestral_pch = 19, value_in_box = FALSE, ancestral_as_shift = FALSE,
  shifts_cex = 0.6, shifts_bg = "chocolate4", root_bg = "chocolate4",
  shifts_adj = 0, root_adj = 1, color_shifts_regimes = FALSE,
  regime_boxes = FALSE, alpha_border = 70, show.tip.label = FALSE,
  label_cex = 0.5, label_font = 1, label_offset = 0, axis_cex = 0.7,
  axis_las = 0, edge.width = 1, margin_plot = NULL, gray_scale = FALSE,
  root.edge = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{PhyloEM}, result of function
\code{\link{PhyloEM}}.}

\item{traits}{a vector of integers giving the numbers of the trait to be plotted.
Default to 1:p (all the traits).}

\item{params}{(optional) some user-specified parameters.
Must be of class \code{\link{params_process}}. If left blank, there are extracted
using the \code{method.selection} argument (see below).}

\item{method.selection}{select the parameters to plot. One of "LINselect", "DDSE",
"Djump". Default to "LINselect". See
\code{\link{params_process.PhyloEM}}.}

\item{automatic_colors}{whether to color the edges automatically according to
their regimes. Default to TRUE. If FALSE, colors can be manually specified through
arguments \code{color_characters} and \code{colro_edges} (see below).}

\item{color_characters}{if \code{automatic_colors=FALSE}, a vector of colors for
the tips of the tree.}

\item{color_edges}{if \code{automatic_colors=FALSE}, a vector of colors for the
edges of the tree.}

\item{plot_ancestral_states}{whether to plot the ancestral traits inferred at the
internal nodes of the tree. Only available if only one trait is plotted. Default
to FALSE.}

\item{imposed_scale}{if \code{plot_ancestral_states=TRUE}, a vector specifying the
imposed scale for the ancestral states plotting. Useful to make comparisons.
Default to the plotted trait.}

\item{ancestral_cex}{if \code{plot_ancestral_states=TRUE}, the size of the
ancestral states on the tree. Default to 2.}

\item{ancestral_pch}{if \code{plot_ancestral_states=TRUE}, the symbol used of the 
ancestral states. Default to circles (\code{pch=19}).}

\item{value_in_box}{whether to plot the value of the shift in a box on the edges.
Only available when only one trait is plotted. Can be difficult to read on big
trees. The size of the text in the boxes is controlled by parameter.
Default to FALSE.}

\item{ancestral_as_shift}{whether to represent the ancestral value at the root
as an ancestral shift on the root edge. Default to FALSE.
\code{shifts_cex} (see below).}

\item{shifts_cex}{if \code{value_in_box=TRUE}, the size of the text in the boxes.
Default to 0.8.}

\item{shifts_bg}{if \code{value_in_box=TRUE}, the background color of the boxes.}

\item{root_bg}{if \code{value_in_box=TRUE} and \code{ancestral_as_shift=TRUE},
the background color of the ancestral box.}

\item{shifts_adj}{the adj parameter for the shifts position on the edges. Default
to 0 (beginning of the edge).}

\item{root_adj}{if \code{ancestral_as_shift=TRUE}, the adj parameter for the
ancestral value position on the root edge. Default to 1.}

\item{color_shifts_regimes}{whether to color each shift according to its regime
(default to the same color of the edge it's on). Default to FALSE.}

\item{regime_boxes}{whether to draw a box showing all the tips below a given.
The transparency of the border of the box is controlled by parameter
\code{alpha_border} (see below).}

\item{alpha_border}{if \code{regime_boxes=TRUE}, the alpha parameter of
the border of the box. Default to 70.}

\item{show.tip.label}{whether to show the tip labels. Default to FALSE.}

\item{label_cex}{if \code{show.tip.label=TRUE}, the size of the labels. Default
to 0.5.}

\item{label_font}{if \code{show.tip.label=TRUE}, the font of the labels (see \link{par}).}

\item{label_offset}{if \code{show.tip.label=TRUE}, the size of the offset between
the tree and the labels. Default to 0.}

\item{axis_cex}{cex for the label values of the plot. Default to 0.7.}

\item{axis_las}{las for the label values of the plot. Default to 0 (see \link{par}).}

\item{edge.width}{width of the edge. Default to 1.}

\item{margin_plot}{vector giving the margin to around the plot.
Default to \code{c(0, 0, 0, 0)}.}

\item{gray_scale}{if TRUE, the colors are replaced by a gray scale.
Default to FALSE.}

\item{root.edge}{a logical indicating whether to draw the root edge (defaults to TRUE)}

\item{...}{further arguments to be passed to \code{\link{plot.phylo}}.}
}
\description{
This function takes an object of class \code{PhyloEM}, result of function
\code{\link{PhyloEM}}, and plots the result of the inference.
}
\seealso{
\code{\link{params_process.PhyloEM}}, \code{\link{imputed_traits.PhyloEM}}
}
