% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{penalty_BirgeMassart_shape1}
\alias{penalty_BirgeMassart_shape1}
\title{Penalty function type Birgé-Massart 1}
\usage{
penalty_BirgeMassart_shape1(K, p, model_complexity, B = 0.1)
}
\arguments{
\item{K}{the number of shifts}

\item{p}{the dimension of the data}

\item{model_complexity}{the complexity of the set of models with dimension K}

\item{B}{a non-negative constant. Default is 0.1 
(as suggested in Cleymen Lebarbier 2015)}
}
\value{
value of the penalty
}
\description{
\code{penalty_BirgeMassart_shape1} is the penalty shape defined by : 
pen_shape = (sqrt(K) + sqrt(2 * K * L_K))^2 with sum(exp(- K * L_K)) < infty :
L_K = B + 1/K * log(model_complexity).
}
\details{
See Birgé Massart (2001).
Must be applied to least-square criterion.
This penalty should be calibrated using the slope heuristic.
}
\seealso{
\code{\link{penalty_BaraudGiraudHuet_likelihood}},
\code{\link{penalty_BirgeMassart_shape2}}
}
\keyword{internal}
