% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preflib.R
\name{preflib}
\alias{preflib}
\alias{read.soc}
\alias{read.soi}
\alias{read.toc}
\alias{read.toi}
\alias{as.aggregated_rankings.preflib}
\title{Read Preflib Election Data Files}
\usage{
read.soc(file)

read.soi(file)

read.toc(file)

read.toi(file)

\method{as.aggregated_rankings}{preflib}(x, ...)
}
\arguments{
\item{file}{An election data file, conventionally with extension \code{.soc},
\code{.soi}, \code{.toc} or \code{.toi} according to data type.}

\item{x}{An object of class \code{"preflib"}.}

\item{...}{Additional arguments passed to \code{\link[=as.rankings]{as.rankings()}}: \code{freq},
\code{input} or \code{items} will be ignored with a warning as they are set
automatically.}
}
\value{
A data frame of class \code{"preflib"} with first column \code{Freq},
giving the frequency of the ranking in that row, and remaining columns
\code{Rank 1}, \ldots, \code{Rank p} giving the items ranked from first to
last place in that ranking. Ties are represented by vector elements in list
columns. The data frame has an attribute \code{"items"} giving the labels
corresponding to each item number.
}
\description{
Read orderings from \code{.soc}, \code{.soi}, \code{.toc} or \code{.toi} file types storing
election data as defined by
\href{http://www.preflib.org/}{{PrefLib}: A Library for Preferences}.
}
\details{
The file types supported are
\describe{
\item{.soc}{Strict Orders - Complete List}
\item{.soi}{Strict Orders - Incomplete List}
\item{.toc}{Orders with Ties - Complete List}
\item{.toi}{Orders with Ties - Incomplete List}
}
Note that the file types do not distinguish between types of incomplete
orderings, i.e. whether they are a complete ranking of a subset of items
(as supported by \code{\link[=PlackettLuce]{PlackettLuce()}}) or top-\eqn{r} rankings of \eqn{n} items
from the full set of items (not currently supported by \code{\link[=PlackettLuce]{PlackettLuce()}}).

The numerically coded orderings and their frequencies are read into a
data frame, storing the item names as an attribute. The
\code{as.aggregated_rankings} method converts these to an
\code{\link[=aggregate.rankings]{"aggregated_rankings"}} object with the items labelled
by the item names.
}
\examples{

# can take a little while depending on speed of internet connection

\dontrun{
# url for preflib data in the "Election Data" category
preflib <- "http://www.preflib.org/data/election/"

# strict complete orderings of four films on Netflix
netflix <- read.soc(file.path(preflib, "netflix/ED-00004-00000101.soc"))
head(netflix)
attr(netflix, "items")

head(as.rankings(netflix))

# strict incomplete orderings of 6 random cities from 36 in total
cities <- read.soi(file.path(preflib, "cities/ED-00034-00000001.soi"))

# strict incomplete orderings of drivers in the 1961 F1 races
# 8 races with 17 to 34 drivers in each
f1 <- read.soi(file.path(preflib, "f1/ED-00010-00000001.soi"))

# complete orderings with ties of 30 skaters
skaters <- read.toc(file.path(preflib, "skate/ED-00006-00000001.toc"))

# incomplete orderings with ties of 10 sushi items from 100 total
# orderings were derived from numeric ratings
sushi <- read.toi(file.path(preflib, "sushi/ED-00014-00000003.toi"))
}
}
\references{
Mattei, N. and Walsh, T. (2013) PrefLib: A Library of Preference Data.
\emph{Proceedings of Third International Conference on Algorithmic Decision
Theory (ADT 2013)}. Lecture Notes in Artificial Intelligence, Springer.
}
