% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntibodyForests_label_propagation.R
\name{AntibodyForests_label_propagation}
\alias{AntibodyForests_label_propagation}
\title{Propagate label annotations/values on sparsely labeled networks as AntibodyForests objects.}
\usage{
AntibodyForests_label_propagation(
  trees,
  features,
  propagation.algorithm,
  diffusion.n.iter,
  diffusion.threshold,
  parallel
)
}
\arguments{
\item{trees}{nested list of AntibodyForests objects or single object, as obtained from the AntibodyForests function.}

\item{features}{vector of strings - features to be propagated in the graph. Must be performed on sparsely-labeled graphs (with NA node attribute values).}

\item{propagation.algorithm}{string - label propagation/diffusion algorithm to be used. If propagation.algorithm = 'diffusion', will perform label propagation using the graph heat diffusion method (http://mlg.eng.cam.ac.uk/zoubin/papers/CMU-CALD-02-107.pdf), 'neighbours' for neihbour majority voting propagation (https://arxiv.org/abs/0709.2938).}

\item{diffusion.n.iter}{integer - number of diffusion iteration if propagation.algorithm = 'diffusion'.}

\item{diffusion.threshold}{numeric - probability min. threshold for the diffusion algorithm.}

\item{parallel}{boolean - whether to execute the main subroutine in parallel or not. Requires the 'parallel' R package to be installed.}
}
\value{
Nested list of AntibodyForests objects or single object with new propagated labels added as vertex attributes (e.g., feature_label_propagation will be a new vertex attribute in the resulting AntibodyForests objects).
}
\description{
Performs label diffusion/propagation, using two different algorithms: if propagation.algorithm = 'diffusion', will perform label propagation using the graph heat diffusion method (http://mlg.eng.cam.ac.uk/zoubin/papers/CMU-CALD-02-107.pdf), 'neighbours' for neihbour majority voting propagation (https://arxiv.org/abs/0709.2938).
}
\examples{
\dontrun{
AntibodyForests_label_propagation(ova_trees,
features = 'OVA_binder',
propagation.algorithm = 'diffusion', parallel = T)
}
}
