% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{plotftir_to_chemospec}
\alias{plotftir_to_chemospec}
\title{Convert `PlotFTIR` data to `ChemoSpec` format}
\usage{
plotftir_to_chemospec(
  ftir,
  group_crit = NA,
  group_colours = "auto",
  description = "FTIR Study"
)
}
\arguments{
\item{ftir}{A data.frame in long format with columns `sample_id`,
  `wavenumber`, and `absorbance`. The `absorbance` column may be replaced by
  a `transmittance` column for transmittance plots. The code determines the
  correct y axis units and labels the plot/adjusts the margins appropriately.

  Un data.frame au format long avec les colonnes `sample_id`, `wavenumber`,
  et `absorbance`. La colonne `absorbance` peut être remplacée par une
  colonne `transmittance` pour les tracés de transmission. Le code détermine
  les unités correctes de l'axe y et étiquette le tracé/ajuste les marges de
  manière appropriée.}

\item{group_crit}{A vector of character strings. Corresponds to [ChemoSpec::files2SpectraObject()] `gr.crit` parameter.

Un vecteur de chaînes de caractères. Correspond au paramètre `gr.crit` de [ChemoSpec::files2SpectraObject()].}

\item{group_colours}{Group colours. Corresponds to [ChemoSpec::files2SpectraObject()] `gr.cols` parameter.

Couleurs du groupe. Correspond au paramètre `gr.cols` de [ChemoSpec::files2SpectraObject()].}

\item{description}{A description of the experiment. Corresponds to [ChemoSpec::files2SpectraObject()] `descrip` parameter.

Description de l'expérience. Correspond au paramètre `descrip` de [ChemoSpec::files2SpectraObject()].}
}
\value{
A `ChemoSpec` data object

Un objet de données `ChemoSpec`
}
\description{
Converts `PlotFTIR` data to that ready to use by the `ChemoSpec` package.

Convertit les données `PlotFTIR` en données prêtes à être utilisées par le paquet `ChemoSpec`.
}
\examples{
if (requireNamespace("ChemoSpec", quietly = TRUE) && interactive()) {
  # convert biodiesel to a `chemospec` object
  plotftir_to_chemospec(biodiesel)
}
}
\seealso{
[ChemoSpec::files2SpectraObject()] for import requirements, and [chemospec_to_plotftir()] for converting to `PlotFTIR` format.

[ChemoSpec::files2SpectraObject()] pour les conditions d'importation, et [chemospec_to_plotftir()] pour la conversion au format `PlotFTIR`.
}
