% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulations.R
\name{highlight_sample}
\alias{highlight_sample}
\title{Highlight Sample Spectra}
\usage{
highlight_sample(ftir_spectra_plot, sample_ids, ...)
}
\arguments{
\item{ftir_spectra_plot}{A plot generated by \code{\link[=plot_ftir]{plot_ftir()}} or
\code{\link[=plot_ftir_stacked]{plot_ftir_stacked()}}.

Un tracé généré par \code{\link[=plot_ftir]{plot_ftir()}} ou \code{\link[=plot_ftir_stacked]{plot_ftir_stacked()}}.}

\item{sample_ids}{A vector of one or more \code{sample_id}s from the \code{ftir_spectra_plot} to highlight.

Un vecteur d'un ou plusieurs \code{sample_id}s du \code{ftir_spectra_plot} à souligner.}

\item{...}{Additional parameters to pass to \code{\link[gghighlight:gghighlight]{gghighlight::gghighlight()}}.

Paramètres supplémentaires à passer à \code{\link[gghighlight:gghighlight]{gghighlight::gghighlight()}}.}
}
\value{
the FTIR plot as a ggplot2 object, with selected sample spectra highlighted.

le tracé FTIR en tant qu'objet ggplot2, avec les spectres de l'échantillon sélectionné soulignier.
}
\description{
Highlight one or more sample spectra on a spectral image. Changes all un-selected \code{sample_id}s to grey lines. Requires \code{\link[gghighlight:gghighlight]{gghighlight::gghighlight()}} to function.

Surligne un ou plusieurs spectres d'échantillons sur une image spectrale. Change tous les spectres \code{sample_id}s non sélectionnés en lignes grises. Nécessite \code{\link[gghighlight:gghighlight]{gghighlight::gghighlight()}} pour fonctionner.
}
\examples{
if (requireNamespace("ggplot2", quietly = TRUE) & requireNamespace("gghighlight", quietly = TRUE)) {
  # Generate a plot
  p <- plot_ftir(sample_spectra)

  # Highlight one sample:
  highlight_sample(p, "isopropanol")
}
}
\seealso{
\code{\link[gghighlight:gghighlight]{gghighlight::gghighlight()}}
}
