% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbinom.R
\name{PoissonBinomial-Distribution}
\alias{PoissonBinomial-Distribution}
\alias{dpbinom}
\alias{ppbinom}
\alias{qpbinom}
\alias{rpbinom}
\title{The Poisson Binomial Distribution}
\usage{
dpbinom(x, probs, wts = NULL, method = "DivideFFT", log = FALSE)

ppbinom(
  x,
  probs,
  wts = NULL,
  method = "DivideFFT",
  lower.tail = TRUE,
  log.p = FALSE
)

qpbinom(
  p,
  probs,
  wts = NULL,
  method = "DivideFFT",
  lower.tail = TRUE,
  log.p = FALSE
)

rpbinom(n, probs, wts = NULL, method = "DivideFFT")
}
\arguments{
\item{x}{Either a vector of observed numbers of successes or NULL.
If NULL, probabilities of all possible observations are
returned.}

\item{probs}{Vector of probabilities of success of each Bernoulli
trial.}

\item{wts}{Vector of non-negative integer weights for the input
probabilities.}

\item{method}{Character string that specifies the method of computation
and must be one of \code{"DivideFFT"}, \code{"Convolve"},
\code{"Characteristic"}, \code{"Recursive"},
\code{"Mean"}, \code{"GeoMean"}, \code{"GeoMeanCounter"},
\code{"Poisson"}, \code{"Normal"} or
\code{"RefinedNormal"} (abbreviations are allowed).}

\item{log, log.p}{Logical value indicating if results are given as
logarithms.}

\item{lower.tail}{Logical value indicating if results are \eqn{P[X \leq x]}
(if \code{TRUE}; default) or \eqn{P[X > x]} (if 
\code{FALSE}).}

\item{p}{Vector of probabilities for computation of quantiles.}

\item{n}{Number of observations. If \code{length(n) > 1}, the
length is taken to be the number required.}
}
\value{
\code{dpbinom} gives the density, \code{ppbinom} computes the distribution
function, \code{qpbinom} gives the quantile function and \code{rpbinom}
generates random deviates.

For \code{rpbinom}, the length of the result is determined by \code{n}, and
is the lengths of the numerical arguments for the other functions.
}
\description{
Density, distribution function, quantile function and random generation for
the Poisson binomial distribution with probability vector \code{probs}.
}
\details{
See the references for computational details. The \emph{Divide and Conquer}
(\code{"DivideFFT"}) and \emph{Direct Convolution} (\code{"Convolve"})
algorithms are derived and described in Biscarri, Zhao & Brunner (2018). The
\emph{Discrete Fourier Transformation of the Characteristic Function}
(\code{"Characteristic"}), the \emph{Recursive Formula} (\code{"Recursive"}),
the \emph{Poisson Approximation} (\code{"Poisson"}), the
\emph{Normal Approach} (\code{"Normal"}) and the
\emph{Refined Normal Approach} (\code{"RefinedNormal"}) are described in Hong
(2013). The calculation of the \emph{Recursive Formula} was modified to
overcome the excessive memory requirements of Hong's implementation.

The \code{"Mean"} method is a naive binomial approach using the arithmetic
mean of the probabilities of success. Similarly, the \code{"GeoMean"} and
\code{"GeoMeanCounter"} procedures are binomial approximations, too, but
they form the geometric mean of the probabilities of success
(\code{"GeoMean"}) and their counter probabilities (\code{"GeoMeanCounter"}),
respectively.

In some special cases regarding the values of \code{probs}, the \code{method}
parameter is ignored (see Introduction vignette).
}
\section{References}{

Hong, Y. (2013). On computing the distribution function for the Poisson
   binomial distribution. \emph{Computational Statistics & Data Analysis},
   \strong{59}, pp. 41-51. doi:
   \href{https://doi.org/10.1016/j.csda.2012.10.006}{
   10.1016/j.csda.2012.10.006}

Biscarri, W., Zhao, S. D. and Brunner, R. J. (2018) A simple and fast method
   for computing the Poisson binomial distribution.
   \emph{Computational Statistics and Data Analysis}, \strong{31}, pp.
   216–222. doi: \href{https://doi.org/10.1016/j.csda.2018.01.007}{
   10.1016/j.csda.2018.01.007}
}

\examples{
set.seed(1)
pp <- c(0, 0, runif(995), 1, 1, 1)
qq <- seq(0, 1, 0.01)

dpbinom(NULL, pp, method = "DivideFFT")
ppbinom(450:550, pp, method = "DivideFFT")
qpbinom(qq, pp, method = "DivideFFT")
rpbinom(100, pp, method = "DivideFFT")

dpbinom(NULL, pp, method = "Convolve")
ppbinom(450:550, pp, method = "Convolve")
qpbinom(qq, pp, method = "Convolve")
rpbinom(100, pp, method = "Convolve")

dpbinom(NULL, pp, method = "Characteristic")
ppbinom(450:550, pp, method = "Characteristic")
qpbinom(qq, pp, method = "Characteristic")
rpbinom(100, pp, method = "Characteristic")

dpbinom(NULL, pp, method = "Recursive")
ppbinom(450:550, pp, method = "Recursive")
qpbinom(qq, pp, method = "Recursive")
rpbinom(100, pp, method = "Recursive")

dpbinom(NULL, pp, method = "Mean")
ppbinom(450:550, pp, method = "Mean")
qpbinom(qq, pp, method = "Mean")
rpbinom(100, pp, method = "Mean")

dpbinom(NULL, pp, method = "GeoMean")
ppbinom(450:550, pp, method = "GeoMean")
qpbinom(qq, pp, method = "GeoMean")
rpbinom(100, pp, method = "GeoMean")

dpbinom(NULL, pp, method = "GeoMeanCounter")
ppbinom(450:550, pp, method = "GeoMeanCounter")
qpbinom(qq, pp, method = "GeoMeanCounter")
rpbinom(100, pp, method = "GeoMeanCounter")

dpbinom(NULL, pp, method = "Poisson")
ppbinom(450:550, pp, method = "Poisson")
qpbinom(qq, pp, method = "Poisson")
rpbinom(100, pp, method = "Poisson")

dpbinom(NULL, pp, method = "Normal")
ppbinom(450:550, pp, method = "Normal")
qpbinom(qq, pp, method = "Normal")
rpbinom(100, pp, method = "Normal")

dpbinom(NULL, pp, method = "RefinedNormal")
ppbinom(450:550, pp, method = "RefinedNormal")
qpbinom(qq, pp, method = "RefinedNormal")
rpbinom(100, pp, method = "RefinedNormal")

}
