% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{haploblock_df2list}
\alias{haploblock_df2list}
\title{convert a haploblock-defining data frame to a list}
\usage{
haploblock_df2list(df, mrkcol, hbcol, sorted=TRUE)
}
\arguments{
\item{df}{a data.frame with at least the following two columns}

\item{mrkcol}{the name or number of the column with the markers}

\item{hbcol}{the name or number of the column with the haploblocks}

\item{sorted}{if TRUE (default) the haploblock list is sorted in alphabetical
order of haploblock name (the markers within haploblocks are not sorted);
if FALSE the haploblocks will be in order of first occurrence in df}
}
\value{
the desired list
}
\description{
convert a haploblock-defining data frame to a list as needed
by inferHaplotypes
}
\details{
function inferHaplotypes needs a list where each item is a
vector of all markers in one haploblock. This function produces such a list
from a data.frame where the markers are in one column and the haploblocks
in another column. The markers and haploblocks columns may be character,
factor or numeric, and the columns may be indicated by name or number.
}
\examples{
df1 <- data.frame(
 marker=paste0("mrk",1:9),
 block=LETTERS[c(1,2,3,2,3,1,1,2,2)],
 extracol=runif(9))
haploblock_df2list(df=df1, mrkcol="marker", hbcol=2)
}
