% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{HornedLizard_Pop}
\alias{HornedLizard_Pop}
\title{A population assignment data frame to be used in \code{Div_stats} and \code{Dif_stats}.}
\format{
A data frame with 4 columns and 72 rows:
\describe{
\item{Sample}{Sample Name}
\item{Population}{Population assignment according to sNMF results (see citation)}
\item{Longitude}{Longitude}
\item{Latitude}{Latitude}

...
}
}
\source{
Coordinates and population names taken from Farleigh, K., Vladimirova, S. A., Blair, C., Bracken, J. T., Koochekian, N., Schield, D. R., ... & Jezkova, T. (2021). The effects of climate and demographic history in shaping genomic variation across populations of the Desert Horned Lizard (Phrynosoma platyrhinos). Molecular Ecology, 30(18), 4481-4496.
}
\usage{
data(HornedLizard_Pop)
}
\description{
Data frame containing 4 columns and 72 rows
}
\examples{
 \donttest{
data("HornedLizard_Pop")
data("HornedLizard_VCF")
Test <- Div_stats(VCF = HornedLizard_VCF, pops = HornedLizard_Pop,
ploidy = 2, write = FALSE)}


}
\keyword{datasets}
