/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session.tcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.openfast.session.Connection;
import org.openfast.session.ConnectionListener;
import org.openfast.session.Endpoint;
import org.openfast.session.FastConnectionException;
import org.openfast.session.tcp.TcpConnection;

public class TcpEndpoint
implements Endpoint {
    private final int port;
    private String host;
    private ConnectionListener connectionListener = ConnectionListener.NULL;
    private ServerSocket serverSocket;
    private boolean closed = true;

    public TcpEndpoint(int port) {
        this.port = port;
    }

    public TcpEndpoint(String host, int port) {
        this(port);
        this.host = host;
    }

    public Connection connect() throws FastConnectionException {
        try {
            Socket socket = new Socket(this.host, this.port);
            TcpConnection connection = new TcpConnection(socket);
            return connection;
        }
        catch (UnknownHostException e) {
            throw new FastConnectionException(e);
        }
        catch (IOException e) {
            throw new FastConnectionException(e);
        }
    }

    public void accept() throws FastConnectionException {
        block5: {
            this.closed = false;
            try {
                this.serverSocket = new ServerSocket(this.port);
                while (!this.closed) {
                    Socket socket = this.serverSocket.accept();
                    try {
                        this.connectionListener.onConnect(new TcpConnection(socket));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                if (this.closed) break block5;
                throw new FastConnectionException(e);
            }
        }
    }

    public void setConnectionListener(ConnectionListener listener) {
        this.connectionListener = listener;
    }

    public void close() {
        this.closed = true;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return String.valueOf(this.host) + ":" + this.port;
    }
}

