/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template;

import java.io.InputStream;
import java.io.Serializable;
import org.openfast.BitVectorBuilder;
import org.openfast.BitVectorReader;
import org.openfast.Context;
import org.openfast.FieldValue;
import org.openfast.QName;
import org.openfast.SimpleNode;
import org.openfast.template.Group;
import org.openfast.template.MessageTemplate;

public abstract class Field
extends SimpleNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected QName key;
    protected final boolean optional;
    protected String id;
    private MessageTemplate template;

    public Field(QName name, boolean optional) {
        super(name);
        this.key = name;
        this.optional = optional;
    }

    public Field(QName name, QName key, boolean optional) {
        super(name);
        this.key = key;
        this.optional = optional;
    }

    public Field(String name, String key, boolean optional, String id) {
        super(new QName(name));
        this.key = new QName(key);
        this.optional = optional;
        this.id = id;
    }

    public String getName() {
        return this.name.getName();
    }

    public QName getQName() {
        return this.name;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public QName getKey() {
        return this.key;
    }

    public void setKey(QName key) {
        this.key = key;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected boolean isPresent(BitVectorReader presenceMapReader) {
        return !this.usesPresenceMapBit() || presenceMapReader.read();
    }

    public abstract byte[] encode(FieldValue var1, Group var2, Context var3, BitVectorBuilder var4);

    public abstract FieldValue decode(InputStream var1, Group var2, Context var3, BitVectorReader var4);

    public abstract boolean usesPresenceMapBit();

    public abstract boolean isPresenceMapBitSet(byte[] var1, FieldValue var2);

    public abstract Class getValueType();

    public abstract FieldValue createValue(String var1);

    public abstract String getTypeName();

    public MessageTemplate getTemplate() {
        return this.template;
    }

    public void setMessageTemplate(MessageTemplate template) {
        this.template = template;
    }
}

