/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.IOException;
import java.io.InputStream;
import org.openfast.Global;
import org.openfast.ScalarValue;
import org.openfast.error.FastConstants;
import org.openfast.template.type.codec.IntegerCodec;

public final class UnsignedInteger
extends IntegerCodec {
    private static final long serialVersionUID = 1L;

    UnsignedInteger() {
    }

    public byte[] encodeValue(ScalarValue scalarValue) {
        long value = scalarValue.toLong();
        int size = UnsignedInteger.getUnsignedIntegerSize(value);
        byte[] encoded = new byte[size];
        int factor = 0;
        while (factor < size) {
            encoded[size - factor - 1] = (byte)(value >> factor * 7 & 0x7FL);
            ++factor;
        }
        return encoded;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScalarValue decode(InputStream in) {
        long value = 0L;
        try {
            int byt;
            do {
                if ((byt = in.read()) < 0) {
                    Global.handleError(FastConstants.END_OF_STREAM, "The end of the input stream has been reached.");
                    return null;
                }
                value = value << 7 | (long)(byt & 0x7F);
            } while ((byt & 0x80) == 0);
            return UnsignedInteger.createValue(value);
        }
        catch (IOException e) {
            Global.handleError(FastConstants.IO_ERROR, "A IO error has been encountered while decoding.", e);
            return null;
        }
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass();
    }
}

