/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openfast.session.Connection;
import org.openfast.session.ConnectionListener;
import org.openfast.session.Endpoint;
import org.openfast.session.FastConnectionException;
import org.openfast.util.RecordingInputStream;
import org.openfast.util.RecordingOutputStream;

public class RecordingEndpoint
implements Endpoint,
ConnectionListener {
    private Endpoint underlyingEndpoint;
    private ConnectionListener listener;

    public RecordingEndpoint(Endpoint endpoint) {
        this.underlyingEndpoint = endpoint;
        this.underlyingEndpoint.setConnectionListener(this);
    }

    public void accept() throws FastConnectionException {
        this.underlyingEndpoint.accept();
    }

    public Connection connect() throws FastConnectionException {
        Connection connection = this.underlyingEndpoint.connect();
        RecordingConnection connectionWrapper = new RecordingConnection(connection);
        return connectionWrapper;
    }

    public void setConnectionListener(ConnectionListener listener) {
        this.listener = listener;
    }

    public void close() {
        this.underlyingEndpoint.close();
    }

    public void onConnect(Connection connection) {
        this.listener.onConnect(new RecordingConnection(connection));
    }

    private final class RecordingConnection
    implements Connection {
        private final RecordingInputStream recordingInputStream;
        private final RecordingOutputStream recordingOutputStream;

        private RecordingConnection(Connection connection) {
            try {
                this.recordingInputStream = new RecordingInputStream(connection.getInputStream());
                this.recordingOutputStream = new RecordingOutputStream(connection.getOutputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            System.out.println("IN: " + new String(this.recordingInputStream.toString()));
            System.out.println("OUT: " + new String(this.recordingOutputStream.toString()));
        }

        public InputStream getInputStream() throws IOException {
            return this.recordingInputStream;
        }

        public OutputStream getOutputStream() throws IOException {
            return this.recordingOutputStream;
        }
    }
}

